#ifndef MMeshCreator_Header
#define MMeshCreator_Header

#include "ModelGeneric.h"


namespace Aztec {

  class MMeshCreator;
  typedef MRefCountedPtr<MMeshCreator> MMeshCreatorPtr;

}

#include "MNamedObject.h"
#include "MMeshShape.h"

namespace Aztec {

  /**
   * An MMeshCreator is an object which creates a mesh shape out of nothing.
   * It may have several input parameters defning how the object is formed,
   * but it is in a general sense, something that generates a new mesh, rather
   * that just modifying a old one.
   *
   * A Mesh creator has one output parameter, "meshOut", which is an 
   * MObjectParameter that contains an MMeshShape object. Other objects
   * connect to this parameter to perform some operations on it.
   *
   * Implementations of this object should override the doObjectUpdate()
   * method to populate the output shape object.
   */
  class MGENEXPORT MMeshCreator : public MNamedObject {
  public:
    MMeshCreator();
    ~MMeshCreator();

    /**
     * This gets the shape object that this creator is outputting to.
     * Deriving classes often use this value to fill up a mesh shape with 
     * useful data.
     */
    MMeshShapePtr getOutputShape();

    /**
     * This gets the parameter that stores our output shape. This should be 
     * used when linking this creator to other things.
     */
    MObjectParameterPtr getOutputParameter();

    // MBaseObject methods. These are declared pure virtual once more
    // to ensure that implementing classes actually put these methods in.
    virtual MStr getClassName() = 0;
    virtual MBaseObjectPtr createNew() = 0;

  protected:
    /**
     * This is the input parameter object.
     */
    MObjectParameterPtr outputShapeParam;
  };
 
}

#endif
