#ifndef MAggregateParameter_Header
#define MAggregateParameter_Header

#include "ModelGeneric.h"

namespace Aztec {
  
  class MAggregateParameter;
  typedef MRefCountedPtr<MAggregateParameter> MAggregateParameterPtr;

}

#include "MParameterObject.h"
#include <params/MArrayParameter.h>

namespace Aztec {

  /**
   * MParameterObject represents a parameter of some type. A
   * parameter is a value of a specific type, and has three names 
   * associated with it. It has a short name, long name and a friendly name.
   * The names are used to identify the parameter so it can be set 
   * without knowledge of the object that contains the parameters.
   */
  class MGENEXPORT MAggregateParameter : public virtual MParameterObject {
  public:
    /**
     * This gets the number of parameters in this aggregate
     */
    virtual int getMemberCount() = 0;

    /**
     * This gets the parameter member at the given index
     */
    virtual MParameterObjectPtr getMember(int index) = 0;

    /**
     * Gts the name of the member at the given index
     */
    virtual MStr getMemberName(int index) = 0;

    /**
     * Gets the index of the parameter that has the given name.
     * It first checks the short name, then the long name, 
     * and then the friendly name.
     */
    virtual int getMemberIndex(const MStr &name) = 0;

    // MBaseObject methods
    virtual MStr getClassName() { return "MAggregateParameter"; }
  
  };

}

#endif
