#ifndef MFloatKeyParameter_Header
#define MFloatKeyParameter_Header

#include "ModelGeneric.h"

namespace Aztec {
  
  class MFloatKeyParameter;
  typedef MRefCountedPtr<MFloatKeyParameter> MFloatKeyParameterPtr;

}

#include <params/MKeyParameter.h>
#include <params/MFloatParameter.h>
#include <MFloatKeyList.h>
#include <MFloatKey.h>

namespace Aztec {
  
  //---------------------------------------
  //  MFloatKeyParameter
  //---------------------------------------
  class MGENEXPORT MFloatKeyParameter : public virtual MKeyParameter, 
                                        public virtual MFloatParameter {
  public:

  protected:
    MFloatKeyParameter() {
    }
    ~MFloatKeyParameter() {
    }
  };

  class MGENEXPORT MFloatKeyParameterImpl : public virtual MFloatKeyParameter,
                                            public MFloatParameterImpl {
  public:
    MFloatKeyParameterImpl(const MStr &shortName = "", 
                           const MStr &longName = "", 
                           const MStr &friendlyName = "",
                           const MFloatKeyableValuePtr &inputFloatList = MFloatKeyableValuePtr(NULL) );
    ~MFloatKeyParameterImpl();

    // MFloatParmeter methods
    virtual float getValue();
    virtual float getValue(long time);

    // MKeyParameter methods
    MKeyableValuePtr getKeyableValue();

    // MParameterObject methods.
    bool setValueFloat(float value);
    bool createKeyAt(long time = 0);
    bool setFromParameter(MParameterObjectPtr src);
    MParameterObjectPtr createCopy();
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MFloatKeyParameter"); }
    bool doUpdateObject();

  protected:
    MFloatKeyableValuePtr m_FloatKeyList;

    void getValueFromTime(long time);
  };

}

#endif
