#include "StdAfx.h"

#include <mesh/ComponentFlagParam.h>
#include <MStr.h>

#include <assert.h>

namespace Aztec {


ComponentFlagParam::ComponentFlagParam(const char *name, MComponentisedObject *object, MComponentisedObject::ComponentType type, int componentIndex)
{
  this->name = name;
  this->object = object;
	this->type = type;
	this->componentIndex = componentIndex;
	setStorable(true);
}

// MIntParameter methods
int ComponentFlagParam::getValue() {
  int result = 0;
  for (int i = 0; i < 32; ++i) {
    if (object->isComponentFlagged(type, componentIndex, 1 << i)) {
      result |= 1 << i;
    }
  }

	return result;
}

// MParameterObject methods
int ComponentFlagParam::getDataType() const {
	return TYPE_INTEGER;
}

int ComponentFlagParam::getDataMeaning() const {
	return MEANING_ANY;
}

MStr ComponentFlagParam::getShortName() const {
  return name;
}

MStr ComponentFlagParam::getLongName() const {
  return name;
}

MStr ComponentFlagParam::getFriendlyName() const {
  return name;
}

MBaseObject* ComponentFlagParam::getOwner() const {
	return AZTEC_CAST(MBaseObject, object);
}

void ComponentFlagParam::setOwner(MBaseObject *newOwner) {
	assert(newOwner == AZTEC_CAST(MBaseObject, object));
}

bool ComponentFlagParam::isInputParameter() {
	return true;
}

bool ComponentFlagParam::getValueString(MStr &value) {
	value = intToStr(getValue());
	return true;
}

bool ComponentFlagParam::getValueInteger(int &value) {
	value = getValue();
	return true;
}

bool ComponentFlagParam::getValueFloat(float &value) {
	value = (float)getValue();
	return true;
}

bool ComponentFlagParam::getValueBoolean(bool &value) {
	return false;
}

bool ComponentFlagParam::getValueVector(MVector3 &value) {
	return false;
}

bool ComponentFlagParam::setValueString(const MStr &value) {
	return setValueInteger(strToInt(value));
}

bool ComponentFlagParam::setValueInteger(int value) {
  for (int i = 0; i < 32; ++i) {
    object->flagComponent(type, componentIndex, 1 << i, ((value >> i) & 0x01) ? MComponentisedObject::atSet : MComponentisedObject::atUnset);
  }

	return true;
}

bool ComponentFlagParam::setValueFloat(float value) {
	return setValueInteger((int)value);
}

bool ComponentFlagParam::setValueBoolean(bool value) {
	return false;
}

bool ComponentFlagParam::setValueVector(const MVector3 &value) {
	return false;
}

bool ComponentFlagParam::setValueParameter(const MParameterObjectPtr &src) {
	int value;
	if (src->getValueInteger(value)) {
		return setValueInteger(value);
	}

	return false;
}

bool ComponentFlagParam::createKeyAt(long time) {
	// Component flags are not animatable
	return false;
}

bool ComponentFlagParam::setFromParameter(MParameterObjectPtr src) {
	int value;
	if (src->getValueInteger(value)) {
		return setValueInteger(value);
	}

	return false;
}

bool ComponentFlagParam::isConnectable() {
	return false;
}

bool ComponentFlagParam::isConnected() {
	return false;
}

bool ComponentFlagParam::setInputParameter(const MParameterObjectPtr &input) {
	return false;
}

MParameterObjectPtr ComponentFlagParam::getInputParameter() {
	return NULL;
}

MParameterObjectPtr ComponentFlagParam::createCopy() {
	return MParameterFactory::createInteger(getShortName(), getLongName(), getFriendlyName());
}


}


