#include "StdAfx.h"

#include <MSystemManager.h>
#include <params/MBooleanParameter.h>

#include <MDAGraph.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MBooleanParameter
  //---------------------
  MBooleanParameterImpl::MBooleanParameterImpl(const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL)
  {
    m_Value = false;
  }
  
  MBooleanParameterImpl::~MBooleanParameterImpl() {
  }
  
  bool MBooleanParameterImpl::getValue() { 
    updateObject();
    return m_Value; 
  }

  bool MBooleanParameterImpl::getValueString(MStr &value) {
    value = boolToStr(getValue());
    return true;
  }

  bool MBooleanParameterImpl::getValueInteger(int &value) {
    value = getValue() ? 1 : 0;
    return true;
  }

  bool MBooleanParameterImpl::getValueFloat(float &value) {
    value = getValue() ? 1.0f : 0.0f;
    return true;
  }

  bool MBooleanParameterImpl::getValueBoolean(bool &value) {
    value = getValue();
    return true;
  }

  bool MBooleanParameterImpl::getValueVector(MVector3 &value) {
    // we cannot convert to a vector, so don't even bother.
    return false;
  }


  bool MBooleanParameterImpl::setValueString(const MStr &value) {
    if (value.ToInt() != 0 ||
        value.compareNoCase("true") == 0 ||
        value.compareNoCase("yes") == 0 || 
        value.compareNoCase("on") == 0) 
    {
      setValueBoolean(true);
      return true;
    } else if (value.compareNoCase("0") == 0 ||
               value.compareNoCase("false") == 0 ||
               value.compareNoCase("no") == 0 || 
               value.compareNoCase("off") == 0) 
    {
      setValueBoolean(false);
      return true;
    }

    return false;
  }

  bool MBooleanParameterImpl::setValueInteger(int value) {
    return setValueBoolean(value != 0);
  }

  bool MBooleanParameterImpl::setValueFloat(float value) {
    return setValueBoolean(value != 0.0f);
  }

  bool MBooleanParameterImpl::setValueBoolean(bool value) {
    // only bother flagging our outputs as changed if we have 
    // actually changed.
    if (m_Value != value) {
      m_Value = value;
      MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    }
    return true;
  }

  bool MBooleanParameterImpl::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MBooleanParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    bool val;
    if (value->getValueBoolean(val)) {
      setValueBoolean(val);
      return true;
    }

    return true;
  }
  
  MParameterObjectPtr MBooleanParameterImpl::createCopy() {
    return createParameterCopy(this);
  }
}
