#ifndef MXYZToolType_Header
#define MXYZToolType_Header

#include <MToolType.h>

#include <OpenGLWnd.h>

//------------------
//  MConstraintType
//------------------
class MConstraintType {
public:
  void setConstraint(const MPlane &plane);
  void setConstraint(const MRay &ray);

  MVector3 getConstrainedPoint(const MRay &srcRay);

  MVector3 getConstraintNormal();
public:
  typedef enum {ctPlane, ctRay} Type;

  Type constraintType;
  MPlane m_Plane;
  MRay m_Ray;
};

//----------------
//  MXYZToolType
//----------------
class MXYZToolType : public MToolType {
public:
  void MarkMeshVerticesComponents(MMeshPtr Mesh, AztecFlags CompMode);
  void PrepareSelectedObjects(MVector3 &Origin, MMatrix4 &SelObjXFormMat);
  void GetPlaneParams(MVector3 &Origin, MVector3 &Dir, MVector3 &ViewNorm, MMatrix4 &XFormMat);
  void GetPlaneParams(MConstraintType &con, const MMatrix4 &axisTransform, AztecFlags flags = 0);
  
  void UpdateKeys(const MStr &UndoName, AztecFlags KeyFlags, bool holdValues = true);
  void CreateUndoNode(const MStr &UndoName, AztecFlags KeyFlags);
  
  int onMouseDown(int X, int Y, const MShiftState &Shift);
  int onMouseUp(int X, int Y, const MShiftState &Shift);
  int onMouseMove(int X, int Y, const MShiftState &Shift);

  void getAxisMatrix(COpenGLWnd *view = NULL);
protected:
  /**
   * This is the constraint which controls how rays are mapped to coordinate.
   */
  MConstraintType m_Constraint;

  /**
   * This is the matrix that represents the current axis we are moving along
   * going form world space to axis space.
   */
  MMatrix4 m_AxisTransform;

  /**
   * This is the inverse of m_AxisTransform
   */
  MMatrix4 m_AxisTransformInv;

  MVector3 m_DownVec, m_UpVec, m_CurVec;    // The cursor coordinates in world space, if necessary

  void updateVectors();
};

#endif