#if !defined(AFX_BASEVIEWWND_H__002F3CB3_1D80_11D3_846B_0040332C7B2F__INCLUDED_)
#define AFX_BASEVIEWWND_H__002F3CB3_1D80_11D3_846B_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// BaseViewWnd.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// MBaseViewWnd window

#include "MScene.h"
#include "MdlConst.h"

#include "MListsTrees.h"
#include <controls/MMenuBar.h>

class MBaseViewWnd;
typedef MRefCountedPtr<MBaseViewWnd> MBaseViewWndPtr;


#include <tools/MToolType.h>

class MBaseViewAttributes {
public:
  /**
   * This is X coordinate of where the first mouse button was pressed.
   */
  int m_DownX;
  /**
   * This is Y coordinate of where the first mouse button was pressed.
   */
  int m_DownY;
  /**
   * This is X coordinate of where the first mouse button was released.
   */
  int m_UpX;
  /**
   * This is Y coordinate of where the first mouse button was released.
   */
  int m_UpY;
};


class MBaseViewWnd : public CWnd, public MBaseViewAttributes, public MNamedObject {
// Construction
public:
  MBaseViewWnd();
  
  // Class related
  virtual MStr getClassName() {return MStr("MBaseViewWnd");};
  virtual MStr getParentClassName() {return MStr("MBaseObject");};
  virtual MBaseObjectPtr createNew();
  
  // virtual function called immediately after Create() or CreateEx()
  virtual void ViewCreate();
  virtual void DrawView();
  virtual void SetViewName(const MStr &Str) { m_ViewName = Str;};

  /**
   * Is this the current view?
   */
  virtual bool isCurrentView();

  /**
   * This sets this view as the current view. Derived classes can override
   * this to ensure that a view window can never be the current view.
   */
  virtual void setAsCurrentView();

  /**
   * This draws a green border around a window to indicate that it is the
   * current view the user is working with.
   */
  static void drawSelectedBorder(HDC dc, RECT &rect, int width = 3, int colour = 0x004C00);

  /**
   * This returns the default tool that should be used when a tool requires
   * selection to happen.
   */
  virtual MToolTypePtr getSelectTool();

  /**
   * This tests to see if anything that the view is interested in is selected 
   * or not. Implementing views override this function to provide information
   * about wether the content we are interested in has been selected or not.
   * For example, testing to see if anything is selected would be different
   * for 3D view than for a UV edit window, or a graph window.
   *
   * @return true if anything is selected, false if nothing is selected.
   */
  virtual bool isAnythingSelected();

  /**
   * This takes the result from a tool's operation, and performs redrawing
   * of the current view, all views, or whatever, based on the result from
   * that tools operation. This function is virtual in case a derived view
   * wants to handle things differently.
   *
   * @param result The result from the tool operation. Typically 
   *               one of TOOLRESULT_DRAWNONE, TOOLRESULT_DRAWALL or
   *               TOOLRESULT_DRAWCURRENT.
   */
  virtual void handleToolResult(int result);

  RECT           m_PopupRect;
  bool           m_RequireRedraw;

  /**
   * This gets the current shift state for the control keys and mouse
   * buttons, such as Contorl, Alt, Shift, Left, Right and the Middle mouse
   * button.
   *
   * @return The current shift state.
   */
  MShiftState getShiftState();
  
  MMenuBar* getMenuBar();

  void GetClientRect(LPRECT rect);
  void GetClientRect(CRect *rect);
  virtual void getClientRect(LPRECT rect);

private:

  MMenuBar *menuBar;

protected:

  MStr           m_ViewName;
  
  /**
   * This method is called by the message handlers of this class when a mouse 
   * button release message has been received on the window. Classes deriving
   * from MBaseViewWnd should override this method if they wish to process 
   * mouse messages.
   *
   * @param X The X coordinate of the mouse in client coordinates.
   * @param Y The Y coordinate of the mouse in client coordinates.
   * @param Shift The state of the buttons at the time of the mouse event.
   */
  virtual void onMouseUp(int X, int Y, MShiftState Shift);

  /**
   * This method is called by the message handlers of this class when a mouse 
   * button press message has been received on the window. Classes deriving
   * from MBaseViewWnd should override this method if they wish to process 
   * mouse messages.
   *
   * @param X The X coordinate of the mouse in client coordinates.
   * @param Y The Y coordinate of the mouse in client coordinates.
   * @param Shift The state of the buttons at the time of the mouse event.
   */
  virtual void onMouseDown(int X, int Y, MShiftState Shift);

  /**
   * This method is called by the message handlers of this class when a mouse 
   * move message has been received on the window. Classes deriving
   * from MBaseViewWnd should override this method if they wish to process 
   * mouse messages.
   *
   * @param X The X coordinate of the mouse in client coordinates.
   * @param Y The Y coordinate of the mouse in client coordinates.
   * @param Shift The state of the buttons at the time of the mouse event.
   */
  virtual void onMouseMove(int X, int Y, MShiftState Shift);

  virtual void onSize();

  virtual DWORD ViewPopupMenu(int x, int y) = 0;
  virtual int HandlePopupCommand(DWORD Cmd);
  virtual int InitPopupMenu(CMenu *PopupMenu);

  LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);

  // Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(MBaseViewWnd)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~MBaseViewWnd();

private:
  MShiftState    m_ShiftState;

  void doMouseDown(int x, int y, MShiftState newState);
  void doMouseUp(int x, int y, MShiftState newState);
  void doMouseMove(int x, int y);

	// Generated message map functions
protected:

	//{{AFX_MSG(MBaseViewWnd)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


// This class is aimed at keeping a list of views that are currently available.
// Used for all view redraws etc.
class MBaseViewWndList {
protected:
   MBaseObjectListPtr m_List;


public:
   MBaseViewWndList();
   virtual ~MBaseViewWndList();

   void AddView(MBaseViewWndPtr View);
   void DeleteView(MBaseViewWndPtr View);
   void DeleteAllViews();

   void DrawAllViews();

   MBaseObjectListPtr getList() {return m_List;};

   MBaseViewWndPtr FindViewOfType(const MStr &Type);
   MBaseViewWndPtr FindViewFromHWND(HWND hWnd);
};

// global function for changing current view
MBaseViewWndPtr SetCurrentView(MBaseViewWndPtr NewView);
MBaseViewWndPtr setCurrentViewForControl(CWnd *wnd);

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BASEVIEWWND_H__002F3CB3_1D80_11D3_846B_0040332C7B2F__INCLUDED_)
