#include <AztecMainPCH.h>

#include "KeyFuncPolyline.h"
#include "MDLGlobs.h"
#include "DLGGlobs.h"

#include "resource.h"

#include <MLineShape.h>
#include <MUIManager.h>

#include <tools/MPolylineAddPointTool.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int polylineAddPoints() {
  g_ToolMan.PushTool(new MPolylineAddPointTool());

  Aztec::MUIManager::setComponentMode(MComponentisedObject::POINT_TYPE);

  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
 
  return 1;
}

void InitPolylineActionList(MActionListType *AL) {
  g_SysMan->logOutput("Initialising Polyline Action List");
  
  // General
  AL->Add("createSquare", "Create Square", "Polyline", createSquare, g_MainDlg, ID_POLYLINE_CREATE_SQUARE);
  AL->Add("toolPolylineAddPoints", "Add Points", "Polyline", polylineAddPoints, g_MainDlg, ID_POLYLINE_ADDPOINTS);
}

int createSquare() {
  Aztec::MSceneObjectPtr sceneObj = new Aztec::MSceneObject();
  Aztec::MLineShapePtr shapeObj = new Aztec::MLineShape();
  Aztec::MLineMeshPtr meshObj = new Aztec::MLineMesh();

  shapeObj->setLineMesh(meshObj);
  sceneObj->setShapeObject(shapeObj);

  sceneObj->setName("square");
  shapeObj->setName("squareShape");
  meshObj->setName("squareMesh");

  meshObj->addVertex(MVector3(-10,-10,0));
  meshObj->addVertex(MVector3( 10,-10,0));
  meshObj->addVertex(MVector3( 10, 10,0));
  meshObj->addVertex(MVector3(-10, 10,0));

  meshObj->addEdge(0, 1);
  meshObj->addEdge(1, 2);
  meshObj->addEdge(2, 3);
  meshObj->addEdge(3, 0);

  g_Scene->addObject(sceneObj);
  g_Scene->addObject(shapeObj);
  return 1;
}

