#include <AztecMainPCH.h>
#include <CameraTools.h>

// AztecLib includes
#include <ModelGLConst.h>

// AztecMain includes
#include <MDLGlobs.h>

// standard includes
#include <math.h>

//---------------------
//  MPanOrbitToolType
//---------------------
int MPanOrbitToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseMove(X, Y, Shift);
  
  if (m_Dragging)
  {
    COpenGLWnd     *GLWnd = AZTEC_CAST(COpenGLWnd, g_CurView);
    
    if (GLWnd == NULL) {
      return TOOLRESULT_DRAWNONE;
    }
    
    if (((int)GLWnd->m_Rot.x+360)%360 >180)
      GLWnd->m_Rot.z -= (float)0.5*(m_OldX - X);
    else
      GLWnd->m_Rot.z += (float)0.5*(m_OldX - X);
    
    GLWnd->m_Rot.x -= (float)0.5*(m_OldY - Y);
    
    if (GLWnd->m_Rot.x<0)
      GLWnd->m_Rot.x += 360;
    if (GLWnd->m_Rot.z<0)
      GLWnd->m_Rot.z += 360;
    
    if (GLWnd->m_Rot.x>360)
      GLWnd->m_Rot.x -= 360;
    if (GLWnd->m_Rot.z>360)
      GLWnd->m_Rot.z -= 360;
    if ( GLWnd->isFlagged(GLVIEW_FLAGS_PERSPECTIVE) == false) {
      if (GLWnd->m_Rot == MVector3(-90,180,0))
        GLWnd->SetViewName("Top");
      else if (GLWnd->m_Rot == MVector3(-90,90,0))
        GLWnd->SetViewName("Front");
      else if (GLWnd->m_Rot == MVector3(0,90,0))
        GLWnd->SetViewName("Right");
      else
        GLWnd->SetViewName("User");
    }
    
    GLWnd->UpdateXFormMatricies();
    
    m_OldX = X;
    m_OldY = Y;
    
    return TOOLRESULT_DRAWCURRENT;
  }
  
  m_OldX = X;
  m_OldY = Y;
  
  return TOOLRESULT_DRAWNONE;
}

//---------------------
//  MPanTrackToolType
//---------------------
int MPanTrackToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseMove(X, Y, Shift);
  
  if (m_Dragging)
  {
    MVector3       T,N;
    float          Mult;
    COpenGLWnd     *GLWnd = AZTEC_CAST(COpenGLWnd, g_CurView);
    
    if (GLWnd == NULL)
      return TOOLRESULT_DRAWNONE;
    
    T.x = (float)(m_OldX - X);
    T.y = (float)(m_OldY - Y);
    T.z = 0;
    
    GLWnd->m_ViewXFormInv.transform(T,N);
    
    if (GLWnd->isFlagged(GLVIEW_FLAGS_PERSPECTIVE))
    {
      if (GLWnd->m_WindowRect.right > GLWnd->m_WindowRect.bottom)
        Mult = (float)GLWnd->m_Dist/GLWnd->m_Aspect*(GLWnd->m_GateRight-GLWnd->m_GateLeft)/1024.0f;
      else
        Mult = (float)GLWnd->m_Dist/GLWnd->m_Aspect*(GLWnd->m_GateTop-GLWnd->m_GateBottom)/1024.0f;
    }
    else
    {
      if (GLWnd->m_WindowRect.right > GLWnd->m_WindowRect.bottom)
        Mult = 1.0f/GLWnd->m_Zoom*(GLWnd->m_GateRight-GLWnd->m_GateLeft)/GLWnd->m_WindowRect.right;
      else
        Mult = 1.0f/GLWnd->m_Zoom*(GLWnd->m_GateTop-GLWnd->m_GateBottom)/GLWnd->m_WindowRect.bottom;
    }
    
    GLWnd->m_Pan.x += Mult * N.x;
    GLWnd->m_Pan.y += Mult * N.y;
    GLWnd->m_Pan.z += Mult * N.z;
    
    m_OldX = X;
    m_OldY = Y;
    
    return TOOLRESULT_DRAWCURRENT;
  }
  
  m_OldX = X;
  m_OldY = Y;
  
  return TOOLRESULT_DRAWNONE;
}



//--------------------
//  MPanZoomToolType
//--------------------
int MPanZoomToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseMove(X, Y, Shift);
  
  if (m_Dragging)
  {
    MVector3       T,N;
    //      float          Mult;
    COpenGLWnd     *GLWnd = AZTEC_CAST(COpenGLWnd, g_CurView);
    
    if (GLWnd == NULL)
      return TOOLRESULT_DRAWNONE;
    
    if (GLWnd->isFlagged(GLVIEW_FLAGS_PERSPECTIVE)) {
      GLWnd->m_Dist += (m_OldX - X);
    } else {
      int diff = m_OldX - X;

      GLWnd->m_Zoom /= pow(1.005, diff);
      GLWnd->AdjustProjectionMatrix();
    }
    
    m_OldX = X;
    m_OldY = Y;
    
    return TOOLRESULT_DRAWCURRENT;
  }
  
  m_OldX = X;
  m_OldY = Y;
  
  return TOOLRESULT_DRAWNONE;
}


