// BasicParamUI.cpp : Defines the initialization routines for the DLL.
//

#include "BasicParamGUIPCH.h"
#include <afxdllx.h>

#include <AztecGUIMParameterPlugin.h>

#include <SceneObjectPlugin.h>
#include <LightShapePlugin.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define BASICPARAMGUI_EXPORT __declspec(dllexport)

BASICPARAMGUI_EXPORT AztecGUI::MParameterPluginPtr getGUIPlugin(int index) {
  switch (index) {
  case 0:
    return new SceneObjectPlugin();
  case 1:
    return new LightShapePlugin();
  default:
    return NULL;
  }
}

BASICPARAMGUI_EXPORT int getGUIPluginCount() {
  return 2;
}



static AFX_EXTENSION_MODULE BasicParamUIDLL = { NULL, NULL };

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Remove this if you use lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE0("BASICPARAMUI.DLL Initializing!\n");
		
		// Extension DLL one-time initialization
		if (!AfxInitExtensionModule(BasicParamUIDLL, hInstance))
			return 0;

		// Insert this DLL into the resource chain
		// NOTE: If this Extension DLL is being implicitly linked to by
		//  an MFC Regular DLL (such as an ActiveX Control)
		//  instead of an MFC application, then you will want to
		//  remove this line from DllMain and put it in a separate
		//  function exported from this Extension DLL.  The Regular DLL
		//  that uses this Extension DLL should then explicitly call that
		//  function to initialize this Extension DLL.  Otherwise,
		//  the CDynLinkLibrary object will not be attached to the
		//  Regular DLL's resource chain, and serious problems will
		//  result.

		new CDynLinkLibrary(BasicParamUIDLL);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE0("BASICPARAMUI.DLL Terminating!\n");
		// Terminate the library before destructors are called
		AfxTermExtensionModule(BasicParamUIDLL);
	}
	return 1;   // ok
}


