// ParticleParamDlg.h: interface for the CParticleParamDlg class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PARTICLEPARAMDLG_H__F5587027_F35A_4EEE_AEB3_3253273C01DB__INCLUDED_)
#define AFX_PARTICLEPARAMDLG_H__F5587027_F35A_4EEE_AEB3_3253273C01DB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"

#include <list>
#include <vector>
#include "PrimParticle.h"

class CParticleParamDlg : public CDialogImpl<CParticleParamDlg>  
{
public:
   enum { IDD = IDD_PARTICLE_SHAPE_DIALOG };

	CParticleParamDlg();
	virtual ~CParticleParamDlg();

	void updateFromObject(MParticlePtr object);

protected:
	HBITMAP upBitmap, downBitmap, deleteBitmap, newBitmap;
	MParticlePtr particleObj;

public:

	BEGIN_MSG_MAP(CParticleParamDlg)
	   	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)

		COMMAND_HANDLER(IDC_DELETE_ACTION_BUTTON, BN_CLICKED, OnBnClickedDeleteActionButton)
		COMMAND_HANDLER(IDC_MOVE_ACTION_DOWN_BUTTON, BN_CLICKED, OnBnClickedMoveActionDownButton)
		COMMAND_HANDLER(IDC_MOVE_ACTION_UP_BUTTON, BN_CLICKED, OnBnClickedMoveActionUpButton)
		COMMAND_HANDLER(IDC_NEW_ACTION_BUTTON, BN_CLICKED, OnBnClickedNewActionButton)
		COMMAND_HANDLER(IDC_PARTICLE_ACTION_LIST, LBN_DBLCLK, OnLbnDblclkParticleActionList)
	END_MSG_MAP()

public:
	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnBnClickedDeleteActionButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedMoveActionDownButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedMoveActionUpButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedNewActionButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnLbnDblclkParticleActionList(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
};

#endif // !defined(AFX_PARTICLEPARAMDLG_H__F5587027_F35A_4EEE_AEB3_3253273C01DB__INCLUDED_)
