#include "StdAfx.h"
#include <stdlib.h>

#include "MParameterObject.h"
#include "PrimTri.h"
#include "MSystemManager.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MPrimitiveTri::MPrimitiveTri()
{
   setFlag(OBJECTFLAG_NOCOMPONENTS);

   m_LastMesh = NULL;
}

MPrimitiveTri::~MPrimitiveTri()
{
}

Aztec::MBaseObjectPtr MPrimitiveTri::createNew() {
   MPrimitiveTri *NewObj;

   NewObj = new MPrimitiveTri;
   NewObj->m_ParamList->setFromList(getParamList());

   return NewObj;
}

void MPrimitiveTri::updateKey(int Time, DWORD Channel, bool CreateKey)
{
}

Aztec::MMeshPtr MPrimitiveTri::convertToMesh() {

   // Create the mesh
   Aztec::MEditableMeshPtr    Mesh;
   Aztec::MVector3 Verts[3];
   Aztec::MTriangle   Tri;

   if (m_LastMesh != NULL) {
        return m_LastMesh;
   }

   Mesh = new Aztec::MEditableMesh();
   m_LastMesh = Mesh;

   // Set vertex values
   Verts[0].set(0, 0, 0);
   Verts[1].set(1, 0, 0);
   Verts[2].set(0, 1, 0);

   // Set triangle references
   Tri.setVertex(0, 0);
   Tri.setVertex(1, 1);
   Tri.setVertex(2, 2);

   Mesh->addVertsAndTriangles(Verts, &Tri, 3, 1);

   Mesh->calculateNormals();

   return Mesh;
}
