#ifndef GraphComponent_Header
#define GraphComponent_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <MFloatValue.h>
#include <MFloatKeyList.h>

#include <controls/AztecGLFontCanvas.h>
#include <tools/MToolType.h>
#include <views/AztecView.h>

namespace AztecGUI {

  using namespace Aztec;

  class GraphPair {
  public:
    GraphPair(MFloatValuePtr v, MVector3 c) 
      : value(v), colour(c) { }

    GraphPair(const GraphPair& src) 
      : value(src.value), colour(src.colour) { }

    MFloatValuePtr value;
    MVector3 colour;
  };

  class GraphComponent : public AztecGLFontCanvas {

  public:
    GraphComponent(AztecView *parentView);
    ~GraphComponent();

    // AztecGLCanvas.h
    void draw3D();

    bool isCurrentView();
    void setAsCurrentView();
    DWORD ViewPopupMenu(int x, int y);
    int HandlePopupCommand(DWORD Cmd);
    MToolTypePtr getSelectTool();
    bool isAnythingSelected();

    void setGraphValues(const std::vector<GraphPair> &values);
    void getGraphValues(std::vector<GraphPair> &values);
  
    typedef std::pair<MFloatKeyListPtr, int> ListKey;

    void clientToGraph(int x, int y, float &nx, float &ny) const;
    void graphToClient(float x, float y, int &nx, int &ny) const;
    void graphToClient(float x, float y, long &nx, long &ny) const;
#ifdef WIN32
    void getKeysInRect(const RECT &rect, std::vector<ListKey> &keys);
#else
#warning TODO: RECT type should be replaced with custom rectangle type (possibly coming from AGUI)
#endif
    void getKeysAtPoint(int x, int y, std::vector<ListKey> &keys, int radius = 3);
    MFloatKeyListPtr getKeyListAtMouse(int mouseX, int mouseY);

    void getGraphRange(float &min, float &max);
    void setGraphRange(float min, float max);

    void getValueRange(float &min, float &max);
    void setValueRange(float min, float max);

    // MComponent methods
    void onCreate();
    bool onPaint();
    bool onMouseReleased(const Aztec::MMouseEvent &event);
    bool onMousePressed(const Aztec::MMouseEvent &event);
    bool onMouseMove(const Aztec::MMouseEvent &event);
    bool onMouseWheel(const Aztec::MMouseEvent &event);

  private:
    AztecView *parentView;
    bool m_Dragging;
    float minTick;
    float maxTick;
    float minValue;
    float maxValue;
    int m_CurX, m_CurY;
    int m_DownX, m_DownY;
    int m_UpX, m_UpY;
    MShiftState shiftState;

    std::vector<GraphPair> graphValues;

    void initialiseRendering();
    void renderXAxis() const;
    void renderYAxis() const;

  };

}

#endif 
