#ifndef ExtrudeTool_Header
#define ExtrudeTool_Header

#include <tools/MXYZToolType.h>

namespace AztecGUI {

  /**
   * This toll is an interactive extrusion tool allowing
   * faces on a polygonal mesh to be selected and extruded.
   * When a set of faces are selected, an handle appears allowing
   * the user to grabe it and extrude fces apropriately.
   */
  class MExtrudeTool : public MToolType
  {
  public:
    MExtrudeTool();
    
    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    
    int WrapMouse() {return 1;};
    int getDefaultManip() {return 3;};

  protected:
     /**
      * This gets the selection normal, and returns true if some
      * face were selected, false if nothing was selected.
      */
     bool updateExtrudeNormal();

     /**
      * This is directio that we are extruding in
      */
     Aztec::MVector3 m_ExtrudeVec;
     /**
      * This is the centre of the extrusion.
      */
     Aztec::MVector3 m_ExtrudeCentre;
     /**
      * This is the transformation matrix to use when
      * drawing the widgets
      */
     Aztec::MMatrix4 m_GLTransform;
     /**
      * This indicates if we are acutally extrusing yet, or
      * just looking at stuff.
      */
     bool m_Extruding;
     /**
      * This is the initial distance along the normal vector
      * the user has selected.
      */
     double m_StartDist;
     /**
      * This is the Distance that we have extruded along
      * the extrude vector so far.
      */
     double m_Dist;


     /**
      * This is the starting point for extrusion.
      */
     Aztec::MVector3 m_StartPos;
     /**
      * This is the current centre of the centre of the
      * faces during extrusion.
      */
     Aztec::MVector3 m_CurrentPos;

  };

}

#endif

