#ifndef SlideEdgeTool_Header
#define SlideEdgeTool_Header

#include <tools/MXYZToolType.h>

// AztecLib includes
#include <MScene.h>
#include <MMath.h>
#include <MEditableMesh.h>

namespace AztecGUI {
  class SlideEdgeTool : public MXYZToolType {
  public:
    SlideEdgeTool();

    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    void initialise();
    bool finish();
    bool cancel();
    bool inProgress();
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int getDefaultManip();

    class SlideEdge {
    public:
      SlideEdge() {
        a = b = -1;
      }
      SlideEdge(int na, int nb) {
        a = na;
        b = nb;
//        if (a > b) std::swap(a,b);
      }

      bool operator<(const SlideEdge &rhs) const {
        if (a < rhs.a) return true;
        if (a > rhs.a) return false;
        if (b < rhs.b) return true;
        return false;
      }

      int a;
      int b;
    };

    typedef std::map<SlideEdge, Aztec::MRay> EdgeRayMap;

  private:
    bool dragging;
    int pickedEdge;
    int draggingPointA;
    int draggingPointB;
    Aztec::MTreeObjectNodePtr draggingNode;
    Aztec::MSceneObjectPtr draggingSceneObj;
    Aztec::MEditableMeshPtr draggingMesh;
    Aztec::MRay draggingRay;


    EdgeRayMap edgeRays;

  };
}
#endif