#ifndef Aztec_ImageView_Header
#define Aztec_ImageView_Header

#include <views/AztecView.h>
#include <gui/MImageComponent.h>

namespace AztecGUI {


  class ImageView : public AztecView {
  public:
    ImageView();
	  ~ImageView();

    /// Prompts the user for an image to load
    bool openImage();
    /// Prompts the user to save an image
    bool saveImageAs();

    void setImage(const Aztec::MImagePtr &image);

    // AztecView Methods
    AztecViewPtr createCopy();
    std::string getViewGroup() const;
    void drawView();

    // MComponent methods
    void onCreate();

  private:
    Aztec::MImageComponentPtr imageComponent;

    Aztec::MImagePtr storedImage;


  };


  typedef Aztec::MRefCountedPtr<ImageView> ImageViewPtr;
}

#endif