#ifndef Aztec2_OutlineView_Header
#define Aztec2_OutlineView_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gui/MTreeControl.h>
#include <gui/MContainer.h>

#include <params/MKeyParameter.h>
#include <params/MVector3KeyParameter.h>

#include <controls/GraphComponent.h>
#include <views/ZoomingView.h>
#include <views/AztecView.h>
#include <views/SelectingView.h>
#include <views/DeletingView.h>

#include <map>

#include <MSceneObject.h>

namespace AztecGUI {


  class OutlineView : public AztecView, 
                      public SelectingView,
                      public DeletingView
  {
  // Construction
  public:
    OutlineView();
	  ~OutlineView();

    void onSelChanged(const MTreeItemPtr &item);

    // AztecView Methods
    AztecViewPtr createCopy();
    std::string getViewGroup() const;
    MToolTypePtr getSelectTool();
    void drawView();

    // MComponent methods
    void onCreate();

    // SelectingView methods
    bool selectParent();
    bool selectChild();
    bool selectSiblingNext();
    bool selectSiblingPrev();
    bool selectNone();
    bool selectAll();
    bool selectInverse();
    bool selectAllChildren();
    bool anythingSelected();
    MVector3 getSelectionCentre();

    // DeletingView methods
    bool deleteSelected();


  private:
    int shiftingSplitPos;
    int m_SplitPos;
    int splitBarWidth;
    int lastXPos;
  
    MTreeControlPtr paramListTree;

    class TreeItemComparator {
    public:
      // this is actually a less than operator.
      bool operator() (const MTreeItemPtr &lhs, const MTreeItemPtr &rhs) const {
        if (lhs == rhs) return false;

        // sort so NULL's always come before non nulls.
        if (lhs == NULL) return true;
        if (rhs == NULL) return false;

        return ( lhs->compare(rhs) == -1);
      }

    };


    std::map<MSceneObjectPtr, MTreeItemPtr> objectItemMap;
    std::map<MTreeItemPtr, MSceneObjectPtr, TreeItemComparator> itemObjectMap;

    std::map<MMaterialPtr, MTreeItemPtr> materialItemMap;
    std::map<MTreeItemPtr, MMaterialPtr, TreeItemComparator> itemMaterialMap;

    bool updatingTree;
    bool updatingSelection;

    void updateTreeFromScene();
    /*
    typedef std::map<MTreeItemPtr, MKeyableValuePtr, TreeItemComparator> ItemParamMap;

    ItemParamMap itemParamMap;
    std::map<MKeyableValuePtr, MTreeItemPtr> paramItemMap;

    typedef std::set<MKeyableValuePtr> KeyParamSet;
    KeyParamSet selectedParams;

    void addParameters(MTreeItemPtr parentItem, const MParameterObjectListPtr &paramList);
    void addParameters(MTreeItemPtr parentItem, const MVector3KeyParameterPtr &vectorParam);

    void addParameter(MTreeItemPtr item, const MKeyableValuePtr &param);
    MKeyableValuePtr getParameterFromTree(MTreeItemPtr item);
    MTreeItemPtr getTreeItem(const MKeyableValuePtr &param);
*/
  };


  typedef MRefCountedPtr<OutlineView> OutlineViewPtr;
}

#endif