
#include <Aztec3DPCH.h>
#include <misc/ResourceManager.h>

#include <controls/AztecGLFontCanvas.h>

#include <utils/AztecGLUtils.h>

#ifdef WIN32
#include <shlobj.h>
#endif

namespace AztecGUI {

  AztecGLFontCanvas::AztecGLFontCanvas() {
    fontsCreated = false;
    monochrome = NULL;

  }

  AztecGLFont* AztecGLFontCanvas::getFont() const {
    if (monochrome == NULL) {
      std::string font;

    #ifdef WIN32
      char buf[1024];
      SHGetSpecialFolderPath(NULL, buf, CSIDL_FONTS, 0);
      std::string path = buf;
      path += "/arial.ttf";
      font = path;
    #else
      // On Linux, we're using the freely redistributable Vera font
      font = Aztec::ResourceManager::locateResource("fonts/Vera.ttf");
    #endif

      monochrome = new AztecGLFont(font.c_str(), 9);
      glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
      monochrome->setForegroundColor(1., 1., 1.);
    }

    return monochrome;
  }

  // MComponent methods
  bool AztecGLFontCanvas::onPaint() {
    bool result = MGLCanvas::onPaint();

    createFonts();

    return result;
  }

  void AztecGLFontCanvas::createFonts() {


//    if (!fontsCreated && paintDC != NULL) {
//      ::SelectObject(paintDC, ::GetStockObject(DEFAULT_GUI_FONT));
//      fontsCreated = (TRUE == wglUseFontBitmaps(paintDC, 0, 255, GL_FONT_START));
//    }
  }


}

