#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {

  int flipNormals(const StringVector &args, std::string &result) {
#ifdef WIN32
	  MBaseObjectTreePtr ObjTree;
	  MTreeObjectNodePtr ObjNode;
	  MBaseObjectPtr Obj;
	  MSceneObjectPtr SceneObj;
	  MEditableMeshPtr ObjMesh;
	  bool FlipChildNormals = false;
    Aztec::MSystemManagerPtr sysMan = Aztec::MSystemManager::getInstance();
	  
	  MParameterObjectPtr Var;
	  Var = g_ProgSet.GetToolParameter("KMeshFlipNormals", "FlipChildNormals"); 
	  if (Var != NULL) {
		  int val;
		  Var->getValueInteger(val);
		  FlipChildNormals = (val != 0);
      Var = NULL;
	  }
	  
	  ObjTree = sysMan->getScene()->getObjectList();
	  
	  ObjTree->beginIteration();
	  while ((Obj = ObjTree->getNext()) != NULL) {
		  ObjNode = ObjTree->getCurrentNode();
		  if (Obj->isFlagged(OBJECTFLAG_SELECTED) || 
			  (ObjNode->isChildOfFlagged(OBJECTFLAG_SELECTED) && FlipChildNormals)) 
		  {
			  SceneObj = AZTEC_CAST(MSceneObject, Obj);
			  if (SceneObj == NULL) {
				  // Note: Should this really be an error?  Suppose a material is selected,
				  // then it should just be ignored, right?
				  sysMan->logOutput("Warning: flipNormals() failed on object '%s', only operates on Objects with a Shape and Mesh output", SceneObj->getName().c_str());
				  continue;
			  }
			  
			  MShapeObjectPtr shapeObj = SceneObj->getShapeObject();
			  if (shapeObj == NULL) {
				  sysMan->logOutput("Warning: flipNormals() failed on object '%s', only operates on Objects with a Shape and Mesh output", SceneObj->getName().c_str());
				  continue;
			  }
			  
			  ObjMesh = AZTEC_CAST(MEditableMesh, shapeObj->convertToMesh());
			  
			  if (ObjMesh == NULL) {
				  sysMan->logOutput("Warning: flipNormals() failed on object '%s', only operates on Objects with a Mesh output", SceneObj->getName().c_str());
				  continue;
			  }
			  
			  AztecFlags FlagsReqd;
			  
			  FlagsReqd = 0xFF;
			  
			  if (ObjMesh->isInComponentMode()) {
				  if (ObjMesh->isInComponentMode(MComponentisedObject::FACET_TYPE)) {
					  FlagsReqd = TRIANGLE_SELECTED;
				  } else {
					  FlagsReqd = 0;
				  }
			  }
			  
			  ObjMesh->flipNormals(FlagsReqd);
		  }
	  }
	  ObjTree->endIteration();
	  
	  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
	  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

#else
#warning TODO: Linux code
#endif
    return FunctionManager::SUCCEED;
  }


}

