#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>
#include <views/AztecGLView.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>
#include <MSceneObject.h>

// Standard includes

namespace AztecGUI {

  int grabFaceUVs(const StringVector &args, std::string &result) {
    Aztec::MBaseObjectPtr Obj;
    Aztec::MVector3 ViewNormal;
    Aztec::MMatrix4 ViewMatrix;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    int i,n, FirstTime = 0;
    
    AztecGLCanvasPtr CurGLView = AztecGLView::getGLCanvasFor(AztecViewManager::getCurrentView());
    
    ViewNormal.set(0,0,1);
    
    ViewMatrix.identity();
    
    if (CurGLView != NULL) {
      ViewMatrix = Aztec::MMatrix4(CurGLView->getModelView());
      
      // We have to transpose it, because opengl uses a different
      // row majorness than us.
      ViewMatrix.transpose();
      
      ViewNormal.set(ViewMatrix.m[0][2], ViewMatrix.m[1][2], ViewMatrix.m[2][2] );
      ViewNormal.normalize();
    }  
    
    scene->getObjectList()->beginIteration();
    
    while (( Obj = scene->getObjectList()->getNext() ) != NULL ) {
      if (!Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }
      
      Aztec::MSceneObjectPtr sceneObject;
      Aztec::MTreeObjectNodePtr sceneObjectNode;
      Aztec::MMeshPtr Mesh, SkinMesh;
      Aztec::MEditableMeshPtr editableSkinMesh;
      Aztec::MMatrix4 worldMatrix, objToViewMatrix;
      
      sceneObject = AZTEC_CAST(Aztec::MSceneObject, Obj);
      
      if (sceneObject == NULL) {
        continue;
      }
      
      if (sceneObject->getShapeObject() != NULL) {
        Mesh = sceneObject->getShapeObject()->convertToMesh();
      }
      
      if (Mesh == NULL) {
        continue;
      }
      
      sceneObjectNode = scene->getObjectList()->getCurrentNode(); 
      scene->getWorldTransformMatrix(sceneObjectNode, worldMatrix);
      
      objToViewMatrix = worldMatrix;
      objToViewMatrix *= ViewMatrix;
      
      ViewNormal.set(objToViewMatrix.m[0][2], objToViewMatrix.m[1][2], objToViewMatrix.m[2][2] );
      ViewNormal.normalize();
      
      SkinMesh = Mesh->getTextureMesh();
      editableSkinMesh = AZTEC_CAST(Aztec::MEditableMesh, SkinMesh);;
      
      // if we do not have a skin mesh, add one in.
      if (SkinMesh == NULL) {
        editableSkinMesh = new Aztec::MEditableMesh();
        editableSkinMesh->setFromMesh(Mesh);
        Mesh->setTextureMesh(editableSkinMesh);
        FirstTime = 1;
        
        // otherwise check to see if we have an editable one
      } else if (editableSkinMesh == NULL) {
        // TODO: We should add in an edit mesh modifier here
        editableSkinMesh = new Aztec::MEditableMesh();
        editableSkinMesh->setFromMesh(Mesh);
        Mesh->setTextureMesh(editableSkinMesh);
        FirstTime = 1;
      }
      
      {      
        bool NothingSelected = true;
        
        // go through the triangles of the mesh, any that are selected, flag them, then separate the faces.
        // Must do this twice, once for front facing, and once for back facing
        
        // Check to see if nothing is selected first. If there is nothing, just assume all is selected
        for (i=0; i<Mesh->getNumTris(); i++) {
          if (Mesh->isTriangleFlagged(i, TRIANGLE_SELECTED)) {
            NothingSelected = false;
            break;
          }
        }
        
        for (i=0; i<Mesh->getNumTris(); i++) {
         
          if (Mesh->isTriangleFlagged(i, TRIANGLE_SELECTED) || NothingSelected) {
            if (ViewNormal * Mesh->getTriangleNormal(i) > 0.0) {
              editableSkinMesh->setTriangleFlag(i, TRIANGLE_FLAGFORCHANGE);
              editableSkinMesh->unsetTriangleFlag(i, TRIANGLE_FLAGFORCHANGE2);
            } else {
              editableSkinMesh->unsetTriangleFlag(i, TRIANGLE_FLAGFORCHANGE);
              editableSkinMesh->setTriangleFlag(i, TRIANGLE_FLAGFORCHANGE2);
            }
          } else {
            editableSkinMesh->unsetTriangleFlag(i, TRIANGLE_FLAGFORCHANGE);
            editableSkinMesh->setTriangleFlag(i, TRIANGLE_FLAGFORCHANGE2);
          }
        }
        editableSkinMesh->separateFaces(TRIANGLE_FLAGFORCHANGE);
        editableSkinMesh->separateFaces(TRIANGLE_FLAGFORCHANGE2);
        
      }
      
      Aztec::MVector3 Min, Max, Size;
      float LargeSize;
      
      // Get the minimum and maximum mesh extents, using the camera transform.
      Mesh->getMeshExtents(Min, Max, objToViewMatrix);
      Size = Max - Min;
      
      LargeSize = Size.x;
      if (Size.y > LargeSize) {
        LargeSize = Size.y;
      }
      if (Size.z > LargeSize) {
        LargeSize = Size.z;
      }
      
      LargeSize = LargeSize * 2;    // Double the size so we can tile a front/back thing
      
      // Now go through and assign uv coords to the mesh
      for (i=0; i<Mesh->getNumTris(); i++) {
        editableSkinMesh->unsetTriangleFlag(i, TRIANGLE_SELECTED);
        if (editableSkinMesh->isTriangleFlagged(i, TRIANGLE_FLAGFORCHANGE | TRIANGLE_FLAGFORCHANGE2)) {
          int meshVertIndex;
          int skinVertIndex;
          editableSkinMesh->setTriangleFlag(i, TRIANGLE_SELECTED);
          
          for (n = 0; n<3; n++) {
            Aztec::MVector3    Pos;
            
            meshVertIndex = Mesh->getTriVert(i, n);
            skinVertIndex = editableSkinMesh->getTriVert(i, n);
            
            Pos = (objToViewMatrix*Mesh->getVertexPosition(meshVertIndex)) - Min;
            Pos *= (float)(1.0 / LargeSize);
            if (editableSkinMesh->isTriangleFlagged(i, TRIANGLE_FLAGFORCHANGE2))
              Pos.x += 0.5f;
            
            Pos.y = 1.0f - Pos.y;
            
            editableSkinMesh->setVertexPosition(skinVertIndex, Pos);
          }
          
        } else if (FirstTime) {
          int skinVertIndex;
          for (n = 0; n<3; n++) {
            skinVertIndex = editableSkinMesh->getTriVert(i, n);
            editableSkinMesh->setVertexPosition(skinVertIndex, Aztec::MVector3(0,0,0));
          }
        }
      }
    }
    scene->getObjectList()->endIteration();
    
    
    AztecViewManager::redrawAllViews();
    
    return FunctionManager::SUCCEED;
  }


}

