#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {

  int separateMeshFacets(const StringVector &args, std::string &result) {
    if ( Aztec::MUIManager::getComponentMode() != Aztec::MComponentisedObject::FACET_TYPE) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: Must be in face mode to separate meshes.");
      return FunctionManager::FAIL;
    }
    
    Aztec::MBaseObjectPtr obj;
    Aztec::MSceneObjectPtr sceneObj;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    std::vector<Aztec::MSceneObjectPtr> objectsToAdd;
    
    Aztec::MSceneObjectPtr newObject;
    Aztec::MMeshShapePtr newMeshShape;
    Aztec::MEditableMeshPtr newMesh;
    
    newObject = new Aztec::MSceneObject();
    newObject->setName("meshObj");
    newMeshShape = new Aztec::MMeshShape();
    newMeshShape->setName("meshObjShape");
    
    newMesh = new Aztec::MEditableMesh();
    newMesh->setName("meshObjMesh");
    newMeshShape->setMeshObject(newMesh);
    newObject->setShapeObject(newMeshShape);
    
    
    scene->getSelectedObjectList()->beginIteration();
    while ((obj = scene->getSelectedObjectList()->getNext()) != NULL) {
      sceneObj = AZTEC_CAST(Aztec::MSceneObject, obj);
      
      // we can only operate on scene objects and those with mesh shape objects
      if (sceneObj == NULL || AZTEC_CAST(Aztec::MMeshShape, sceneObj->getShapeObject()) == NULL) {
        continue;
      }
      if ( sceneObj->getComponentObject() == NULL || 
        !sceneObj->getComponentObject()->isInComponentMode(Aztec::MComponentisedObject::FACET_TYPE) ) {
        continue;
      }
      
      Aztec::MEditableMeshPtr srcMesh = AZTEC_CAST(Aztec::MEditableMesh, AZTEC_CAST(Aztec::MMeshShape, sceneObj->getShapeObject())->getMeshObject());
      Aztec::MVector3 *newVerts;
      Aztec::MTriangle *newTris;
      Aztec::MMatrix4 worldXForm;
      
      scene->getWorldTransformMatrix(scene->getObjectList()->findObject(sceneObj), worldXForm);
      
      std::vector<int> vertIndicies;
      
      vertIndicies.resize(srcMesh->getNumVerts());
      
      // clear the flags on the vertices
      srcMesh->unsetVertexFlags(VERTEX_FLAGFORCHANGE);
      
      // loop over the triangles and flag touching verts
      srcMesh->flagVerticesOnTris(TRIANGLE_SELECTED, VERTEX_FLAGFORCHANGE);
      
      // loop over the vertices and map from old index numbers to new ones
      int vertexCount = 0;
      int triangleCount = srcMesh->getNumTrisFlagged(TRIANGLE_SELECTED);
      
      for (int i = 0; i < srcMesh->getNumVerts(); ++i) {
        if (srcMesh->isVertexFlagged(i, VERTEX_FLAGFORCHANGE)) {
          vertIndicies[i] = vertexCount;
          ++vertexCount;
        } else {
          vertIndicies[i] = -1;
        }
      }
      
      newVerts = new Aztec::MVector3[vertexCount];
      newTris = new Aztec::MTriangle[triangleCount];
      
      
      // loop over the vertices, and copy them appropriately.
      for (int i = 0; i < srcMesh->getNumVerts(); ++i) {
        if (vertIndicies[i] != -1) {
          Aztec::MVector3 pos = newVerts[vertIndicies[i]] = srcMesh->getVertexPosition(i);
          pos = worldXForm * pos;
          newVerts[vertIndicies[i]] = pos;
        }
      }
      
      // loop over the triangles, and adjust the vertices
      triangleCount = 0;
      for (int i = 0; i < srcMesh->getNumTris(); ++i) {
        if (srcMesh->isTriangleFlagged(i, TRIANGLE_SELECTED)) {
          newTris[triangleCount].setVertex(0, vertIndicies[newTris[triangleCount].getVertex(0)]);
          newTris[triangleCount].setVertex(1, vertIndicies[newTris[triangleCount].getVertex(1)]);
          newTris[triangleCount].setVertex(2, vertIndicies[newTris[triangleCount].getVertex(2)]);
          newTris[triangleCount].setEdgeFlag(0, srcMesh->getTriangleEdgeFlag(i, 0));
          newTris[triangleCount].setEdgeFlag(1, srcMesh->getTriangleEdgeFlag(i, 1));
          newTris[triangleCount].setEdgeFlag(2, srcMesh->getTriangleEdgeFlag(i, 2));
          ++triangleCount;
        }
      }
      
      newMesh->addVertsAndTriangles(newVerts, newTris, vertexCount, triangleCount);
      
      srcMesh->deleteTriangleFlag(TRIANGLE_SELECTED);
      sceneObj->getComponentObject()->setComponentMode(Aztec::MComponentisedObject::OBJECT_TYPE);
      
      delete[] newVerts;
      delete[] newTris;
    }
    scene->getSelectedObjectList()->endIteration();
    
    scene->addObject(newObject);
    
    scene->selectNone();
    scene->selectObject(newObject);
    
    newMesh->calculateNormals();
    newMesh->setTriangleFlags(TRIANGLE_SELECTED);
    
    AztecViewManager::redrawAllViews();

    return FunctionManager::SUCCEED;
  }


}

