#include <Aztec3DPCH.h>

#include <functions/view/View3DFunctions.h>
#include<String.h>

// Aztec2 includes
#include <views/AztecViewManager.h>
#include <views/Aztec3DView.h>

#include <scripting/MScriptInterp.h>


namespace AztecGUI {

  static int sceneGLViewToggleGrid(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->getCanvas()->setGridVisible(!view->getCanvas()->getGridVisible());
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewGridOptions(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      Aztec::MScriptInterpreter::getInstance()->ExecuteScript("load('gridOptionsWindow.js');");
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewDisplayOptions(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      Aztec::MScriptInterpreter::getInstance()->ExecuteScript("load('displayOptionsWindow.js');");
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewGetGridRange(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL) {
      result = Aztec::floatToStr(view->getCanvas()->getGridRange()).c_str();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewSetGridRange(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL && args.size() == 1) {
      view->getCanvas()->setGridRange(Aztec::strToFloat(args[0]));
	  return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewGetGridSpacing(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL) {
      result = Aztec::floatToStr(view->getCanvas()->getGridSpacing()).c_str();
	  return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewSetGridSpacing(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL && args.size() == 1) {
      view->getCanvas()->setGridSpacing(Aztec::strToFloat(args[0]));
	  return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewGetGridMajorSpacing(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL) {
      result = Aztec::intToStr(view->getCanvas()->getGridMajorSpacing()).c_str();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewSetGridMajorSpacing(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL && args.size() == 1) {
      view->getCanvas()->setGridMajorSpacing(Aztec::strToInt(args[0]));
	  return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }
////
  static int sceneGLViewGetSnapViaComponentCP(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL) {
      result = Aztec::intToStr(view->getCanvas()->getSnapViaComponentCP()).c_str();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int sceneGLViewSetSnapViaComponentCP(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    if (view != NULL && args.size() == 1) {
      view->getCanvas()->setSnapViaComponentCP(Aztec::strToInt(args[0]));
	  return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }
////


  static int sceneGLViewXYGrid(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->getCanvas()->setGridBasis(Aztec::MVector3(1,0,0), Aztec::MVector3(0,1,0));
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }
  static int sceneGLViewXZGrid(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->getCanvas()->setGridBasis(Aztec::MVector3(1,0,0), Aztec::MVector3(0,0,1));
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }
  static int sceneGLViewYZGrid(const StringVector &args, std::string &result) {
    AztecGLView *view = AZTEC_CAST(AztecGLView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->getCanvas()->setGridBasis(Aztec::MVector3(0,1,0), Aztec::MVector3(0,0,1));
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int scene3DViewGridFromCamera(const StringVector &args, std::string &result) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      Aztec3DSceneCanvasPtr canvas = view->get3DCanvas();
      Aztec::MVector3 u,v;
      canvas->getScreenVectors(u, v);
      view->getCanvas()->setGridBasis(u, v);

      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int changeTexture(Aztec3DSceneCanvas::TextureModeEnum mode) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->get3DCanvas()->setTextureMode(mode);
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int scene3DViewNotTextured(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::TextureNone);
  }

  static int scene3DViewTextureNearest(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::TextureNearest);
  }

  static int scene3DViewTextureLinear(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::TextureLinear);
  }

  static int changeTexture(Aztec3DSceneCanvas::ShadingModeEnum mode) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->get3DCanvas()->setShadingMode(mode);
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }

  static int scene3DViewWireframe(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::ShadingWireframe);
  }
  static int scene3DViewFlat(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::ShadingFlat);
  }
  static int scene3DViewSmooth(const StringVector &args, std::string &result) {
    return changeTexture(Aztec3DSceneCanvas::ShadingSmooth);
  }

  static int scene3DViewToggleBackface(const StringVector &args, std::string &result) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->get3DCanvas()->setBackfaceCulling(!view->get3DCanvas()->getBackfaceCulling());
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }
  static int scene3DViewGetBackfaceState(const StringVector &args, std::string &result) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    if (view != NULL) {
	  result = view->get3DCanvas()->getBackfaceCulling();
      return FunctionManager::SUCCEED;

	}
    return FunctionManager::FAIL;
  }


  static int scene3DViewToggleHeadlight(const StringVector &args, std::string &result) {
    Aztec3DView *view = AZTEC_CAST(Aztec3DView, AztecViewManager::getCurrentView());
    
    if (view != NULL) {
      view->get3DCanvas()->setHeadlight(!view->get3DCanvas()->getHeadlight());
      AztecViewManager::redrawCurrentView();
      return FunctionManager::SUCCEED;
    }
    return FunctionManager::FAIL;
  }


  void registerView3DFunctions(FunctionManager &man) {

    man.registerFunction("scene3DViewToggleGrid", sceneGLViewToggleGrid);
    man.registerFunction("scene3DViewGridOptions", sceneGLViewGridOptions);
    man.registerFunction("scene3DViewGetGridRange", sceneGLViewGetGridRange);
	man.registerFunction("scene3DViewSetGridRange", sceneGLViewSetGridRange);
    man.registerFunction("scene3DViewGetGridSpacing", sceneGLViewGetGridSpacing);
	man.registerFunction("scene3DViewSetGridSpacing", sceneGLViewSetGridSpacing);
	man.registerFunction("scene3DViewGetGridMajorSpacing", sceneGLViewGetGridMajorSpacing);
	man.registerFunction("scene3DViewSetGridMajorSpacing", sceneGLViewSetGridMajorSpacing);
	man.registerFunction("getSnapViaComponentCP", sceneGLViewGetSnapViaComponentCP);
	man.registerFunction("setSnapViaComponentCP", sceneGLViewSetSnapViaComponentCP);
		
	man.registerFunction("scene3DViewDisplayOptions", sceneGLViewDisplayOptions);

    man.registerFunction("scene3DViewXYGrid", sceneGLViewXYGrid);
    man.registerFunction("scene3DViewXZGrid", sceneGLViewXZGrid);
    man.registerFunction("scene3DViewYZGrid", sceneGLViewYZGrid);
    man.registerFunction("scene3DViewGridFromCamera", scene3DViewGridFromCamera);

    man.registerFunction("scene3DViewNotTextured", scene3DViewNotTextured);
    man.registerFunction("scene3DViewTextureNearest", scene3DViewTextureNearest);
    man.registerFunction("scene3DViewTextureLinear", scene3DViewTextureLinear);
    man.registerFunction("scene3DViewSmooth", scene3DViewSmooth);
    man.registerFunction("scene3DViewFlat", scene3DViewFlat);
    man.registerFunction("scene3DViewWireframe", scene3DViewWireframe);
    man.registerFunction("scene3DViewToggleBackface", scene3DViewToggleBackface);
	man.registerFunction("scene3DViewGetBackfaceState", scene3DViewGetBackfaceState);
	
    man.registerFunction("scene3DViewToggleHeadlight", scene3DViewToggleHeadlight);
   

  }


}

