#include <Aztec3DPCH.h>
#include <tools/M3DToolType.h>
#include <controls/AztecGLCanvas.h>

namespace AztecGUI {
   
  const Aztec::MRay& M3DToolType::getDownRay() {
    return downRay;
  }
  const Aztec::MRay& M3DToolType::getUpRay() {
    return upRay;
  }

  const Aztec::MRay& M3DToolType::getCurrentRay() {
    return currentRay;
  }

  
  // MToolType methods
  int M3DToolType::onMouseDown(const Aztec::MMouseEvent &event) {
    int result = MToolType::onMouseDown(event);

    // if we are in a gl canvas window, work out the rays for the mouse cursor.
    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      downRay = canvas->getRay(event.getX(), event.getY());
      currentRay = downRay;
    }

    return result;
  }

  int M3DToolType::onMouseUp(const Aztec::MMouseEvent &event) {
    int result = MToolType::onMouseUp(event);

    // if we are in a gl canvas window, work out the rays for the mouse cursor.
    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      upRay = canvas->getRay(event.getX(), event.getY());
      currentRay = upRay;
    }

    return result;
  }

  int M3DToolType::onMouseMove(const Aztec::MMouseEvent &event) {
    int result = MToolType::onMouseMove(event);

    // if we are in a gl canvas window, work out the rays for the mouse cursor.
    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      currentRay = canvas->getRay(event.getX(), event.getY());
    }

    return result;
  }

}

