#include <Aztec3DPCH.h>

#include <utils/AztecGLUtils.h>
#include <math.h>

#include <GL/gl.h>

namespace AztecGUI {

  using namespace Aztec;

  float getWidgetSize() {
    return 5.0;
  }

  int glDrawAxisIcon(float Size, float Alpha, float LineWidth, bool Select, Aztec::AztecFlags Flags) {
    return glDrawAxisIcon(NULL, Size, Alpha, LineWidth, Select, Flags);
  }

  int glDrawAxisIcon(AztecGLFont *font, float Size, float Alpha, float LineWidth, bool Select, Aztec::AztecFlags Flags, const char *xLabel, const char *yLabel, const char *zLabel) {
    MVector3    XVec, YVec;
    MVector4 colour;
    float       OldLineWidth;
    glMatrixMode(GL_MODELVIEW);
  
    //   glEnable(GL_DEPTH_TEST);
    glGetFloatv(GL_LINE_WIDTH, &OldLineWidth);
    glLineWidth(LineWidth);
    int   Num;
  
    glDisable(GL_CULL_FACE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  
    // for do a for loop, from 1 to 4, for each the
    // axes. 1 = X, 2 = Y, 3 = Z, 4 = that yellow thing in the middle.
    for (Num = 1; Num <= 4; Num++) {
      if (!(Flags & (1 << (Num-1))))
        continue;
    
      if (Select) {
        glPushName(Num);
      }
    
      glPushMatrix();
    
      if (Num == 1) {
        colour.set(1,0,0,Alpha);
        if (Flags & DRAWAXIS_XGRAY) {
          colour.set(0,1,1,Alpha);
        }
      }
      if (Num == 2) {
        colour.set(0,1,0,Alpha);
        glRotatef(90, 0,0,1);
        if (Flags & DRAWAXIS_YGRAY) {
          colour.set(0,1,1,Alpha);
        }
      }
      if (Num == 3) {
        colour.set(0,0,1,Alpha);
        glRotatef(-90, 0,1,0);
        if (Flags & DRAWAXIS_ZGRAY) {
          colour.set(0,1,1,Alpha);
        }
      }
      if (Num == 4) {
        if (Flags & DRAWAXIS_ARROWS) {     // Do we want to draw the yellow square?

          // determine what axis to draw the square on
          if ((Flags & DRAWAXIS_MIDDLE_TYPE) == DRAWAXIS_MIDDLE_NORMAL_X) {
            XVec.set(0, Size*0.1, 0);
            YVec.set(0, 0, Size*0.1);
          } else if ((Flags & DRAWAXIS_MIDDLE_TYPE) == DRAWAXIS_MIDDLE_NORMAL_Y) {
            XVec.set(Size*0.1, 0, 0);
            YVec.set(0, 0, Size*0.1);
          } else if ((Flags & DRAWAXIS_MIDDLE_TYPE) == DRAWAXIS_MIDDLE_NORMAL_Z) {
            XVec.set(Size*0.1, 0, 0);
            YVec.set(0, Size*0.1, 0);
          } else {
            float    Mat[16];
          
            glGetFloatv(GL_MODELVIEW_MATRIX, Mat);
          
            XVec.set(Mat[0], Mat[4], Mat[8]);
            YVec.set(Mat[1], Mat[5], Mat[9]);
          
            XVec.normalize();
            YVec.normalize();
            XVec *= (float)(Size*0.1);
            YVec *= (float)(Size*0.1);
          }
        
          colour.set(1,1,0,Alpha);
          if (Flags & DRAWAXIS_WGRAY) {
            colour.set(0,1,1,Alpha);
          }

          glColor4fv((float*)&colour);
        
          glLineStipple(1, 0x5555);
          glEnable(GL_LINE_STIPPLE);
        
          glScalef(1.1f,1.1f,1.1f);
        
          glLineWidth(1);
        
          if (Select) {
            glBegin(GL_QUADS);
          } else {
            glBegin(GL_LINE_LOOP);
          }
        
          glVertex3f(-XVec.x - YVec.x, -XVec.y - YVec.y, -XVec.z - YVec.z);
          glVertex3f( XVec.x - YVec.x,  XVec.y - YVec.y,  XVec.z - YVec.z);
          glVertex3f( XVec.x + YVec.x,  XVec.y + YVec.y,  XVec.z + YVec.z);
          glVertex3f(-XVec.x + YVec.x, -XVec.y + YVec.y, -XVec.z + YVec.z);
        
          glEnd();
        }            
        glLineWidth(LineWidth);
      
        glDisable(GL_LINE_STIPPLE);
      
        glPopMatrix();
      
        if (Select) {
          glPopName();
        }
        break;
      }
    
      glColor4fv((float*)&colour);
      glBegin(GL_LINES);
      glVertex3f(0,0,0);
      glVertex3f(0.7f*Size,0,0  );
      glEnd();
    
      if (Flags & DRAWAXIS_ARROWS) {     // Draw funky arrow heads
        glPushMatrix();
        glTranslatef((float)(Size*0.7),0,0);
        glDrawArrowHead((float)(Size*0.3), (float)(Size*0.1));
        glPopMatrix();
      }
    
      if (font != NULL && Flags & DRAWAXIS_LABELS) {
        bool oldBlend = glIsEnabled(GL_BLEND);
        bool oldAlphaTest = glIsEnabled(GL_ALPHA_TEST);

        glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
        if (!oldBlend) glEnable(GL_BLEND);
        if (!oldAlphaTest) glEnable(GL_ALPHA_TEST);

        glAlphaFunc(GL_GREATER, 0);
        glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
        
        // Draw X Y Z labels at the end of the sticks
        glRasterPos3f(Size, 0,0);
        font->setForegroundColor(colour.x, colour.y, colour.z);

        switch (Num) {
          case 1: font->draw(xLabel); break;
          case 2: font->draw(yLabel); break;
          case 3: font->draw(zLabel); break;
        }

        // put the blend and alpha test back to the way they were.
        if (!oldBlend) glDisable(GL_BLEND);
        if (!oldAlphaTest) glDisable(GL_ALPHA_TEST);
      }
    
      glPopMatrix();
    
      if (Select) {
        glPopName();
      }
     }
   
     glLineWidth(OldLineWidth);
   
     return 0;
  }

  int glDrawRotateIcon(float Size, float Alpha, float LineWidth, bool Select) {
    float       OldLineWidth;
    MVector3    XVec, YVec, ZVec, ModelX, ModelY, ModelZ;
    glMatrixMode(GL_MODELVIEW);
  
    glPushMatrix();
    glGetFloatv(GL_LINE_WIDTH, &OldLineWidth);
    glLineWidth(LineWidth);
  
    // Draw circle in xy plane, xz, and zy plane
    {
      float    Mat[16];
    
      glGetFloatv(GL_MODELVIEW_MATRIX, Mat);
    
      ModelX.set(Mat[0], Mat[4], Mat[8]);
      ModelY.set(Mat[1], Mat[5], Mat[9]);
      ModelZ.set(Mat[2], Mat[6], Mat[10]);
    
      ModelX.normalize();
      ModelY.normalize();
      ModelZ.normalize();
    
      Mat[0] = ModelX.x; Mat[4] = ModelX.y; Mat[8] = ModelX.z;
      Mat[1] = ModelY.x; Mat[5] = ModelY.y; Mat[9] = ModelY.z;
      Mat[2] = ModelZ.x; Mat[6] = ModelZ.y; Mat[10] = ModelZ.z;
      //      glLoadMatrixf(Mat);
    }
  
  
    float    Ang, Color[4];
    int      Num;
  
    Color[3] = Alpha;
  
    glDisable(GL_CULL_FACE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  
    // for do a for loop, from 1 to 4, for each the
    // axes. 1 = X, 2 = Y, 3 = Z, 4 = that yellow thing in the middle.
    for (Num = 1; Num <= 4; Num++) {
      if (Select) {
        glPushName(Num);
      }
    
      glPushMatrix();
    
      if (Num == 1) {
        Color[0] = 1.0;
        Color[1] = 0.0;
        Color[2] = 0.0;
        XVec.set(0,Size,0);
        YVec.set(0,0,Size);
      }
      if (Num == 2) {
        Color[0] = 0.0;
        Color[1] = 1.0;
        Color[2] = 0.0;
        XVec.set(Size,0,0);
        YVec.set(0,0,Size);
      }
      if (Num == 3) {
        Color[0] = 0.0;
        Color[1] = 0.0;
        Color[2] = 1.0;
        XVec.set(Size,0,0);
        YVec.set(0,Size,0);
      }
      if (Num == 4) {
        Color[0] = 1.0;
        Color[1] = 1.0;
        Color[2] = 0.0;
      
        {
          float    Mat[16];
        
          glGetFloatv(GL_MODELVIEW_MATRIX, Mat);
        
          XVec.set(Mat[0], Mat[4], Mat[8]);
          YVec.set(Mat[1], Mat[5], Mat[9]);
        
          XVec.normalize();
          YVec.normalize();
          XVec *= Size;
          YVec *= Size;
        }
        glLineStipple(1, 0x5555);
        glEnable(GL_LINE_STIPPLE);
      
        glScalef(1.1f,1.1f,1.1f);
      }
  

      glBegin(GL_TRIANGLE_STRIP);
    
      // Draw a fan of tris beginning from the top of the arrow head
      glColor4fv(Color);
      for (Ang=0;Ang<=360;Ang+=10) {
        float       posy, posz;
        MVector3    Pos;
      
        posy = (float)cos(Ang/180.0*M_PI);
        posz = (float)sin(Ang/180.0*M_PI);
      
        glColor4f(Color[0], Color[1], Color[2], Alpha);
        if (Num != 4 && Pos * ModelZ < -0.1) {
          glColor4f(0, 0, 0, Alpha/4);
        }
      
        Pos = posy * XVec * 1.04;
        Pos += posz * YVec * 1.04;

        if (Num != 4 && Pos * ModelZ < -0.1) {
          glColor4f(0, 0, 0, Alpha/4);
        }


        glVertex3f(Pos.x, Pos.y, Pos.z);

        Pos = posy * XVec * 0.96;
        Pos += posz * YVec * 0.96;
        glVertex3f(Pos.x, Pos.y, Pos.z);
        //         glVertex3f(0, posy, posz);
      }
      glEnd();
      

      glPopMatrix();
    
      if (Select)
        glPopName();
    
    }
  
    glDisable(GL_LINE_STIPPLE);
  
    glLineWidth(OldLineWidth);
    glPopMatrix();
  
    return 0;
  }

  int glDrawScaleIcon(float Size, float Alpha, float LineWidth, bool Select) {
    float OldLineWidth;
    glMatrixMode(GL_MODELVIEW);
  
    glGetFloatv(GL_LINE_WIDTH, &OldLineWidth);
    glLineWidth(LineWidth);
    int   Num;
  
    glDisable(GL_CULL_FACE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  
    // for do a for loop, from 1 to 4, for each the
    // axes. 1 = X, 2 = Y, 3 = Z, 4 = that yellow thing in the middle.
    for (Num = 1; Num <= 4; Num++)
    {
      if (Select) {
        glPushName(Num);
      }
    
      glPushMatrix();
    
      if (Num == 1) {
        glColor4f(1,0,0,Alpha);
      }
      if (Num == 2) {
        glColor4f(0,1,0,Alpha);
        glRotatef(90, 0,0,1);
      }
      if (Num == 3) {
        glColor4f(0,0,1,Alpha);
        glRotatef(-90, 0,1,0);
      }
      if (Num == 4) {
        glColor4f(1,1,0,Alpha);
      
        glDrawCube((float)(Size*0.2));
      
        if (Select) {
          glPopName();
        }
      
        glPopMatrix();
      
        break;
      }
    
      glBegin(GL_LINES);
      glVertex3f(0,0,0);
      glVertex3f((float)(0.8*Size),0,0  );
      glEnd();
    
      // Draw funky arrow heads
      glPushMatrix();
      glTranslatef((float)(Size*0.9),0,0);
      glDrawCube((float)(Size*0.2));
      glPopMatrix();
    
      glPopMatrix();
    
      if (Select)
        glPopName();
    }
  
    glLineWidth(OldLineWidth);
  
    return 0;
  }

  int glDrawCube(float Size) {
    float    Size2;
    int      i;
    
    Size2 = Size / 2;
    
    for (i=0;i<6;i++) {
      glPushMatrix();
      
      switch (i) {
      case 0:  glRotatef(0,0,0,0); break;
      case 1:  glRotatef(90,1,0,0); break;
      case 2:  glRotatef(180,1,0,0); break;
      case 3:  glRotatef(270,1,0,0); break;
      case 4:  glRotatef(90,0,1,0); break;
      case 5:  glRotatef(270,0,1,0); break;
      }
      
      glBegin(GL_QUADS);
      
      glVertex3f( Size2,  Size2,  Size2);
      glVertex3f(-Size2,  Size2,  Size2);
      glVertex3f(-Size2, -Size2,  Size2);
      glVertex3f( Size2, -Size2,  Size2);
      
      glEnd();
      
      glPopMatrix();
    }
    return 1;
  }

  int glDrawArrowHead(float Length, float Radius) {
    float Color[4], Ang;
  
    glGetFloatv(GL_CURRENT_COLOR, Color);
  
    // Draw a fan of tris beginning from the top of the arrow head
    glBegin(GL_TRIANGLE_FAN);
  
    glColor4fv(Color);
    glVertex3f(Length,0,0);
    for (Ang=0;Ang<=360;Ang+=10) {
      float posy, posz, factor;
    
      posy = (float)(Radius*cos(Ang/180.0*M_PI));
      posz = (float)(Radius*sin(Ang/180.0*M_PI));
      factor = (float)((fabs(Ang-180))/360);
    
      glColor4f(Color[0]*factor, Color[1]*factor, Color[2]*factor, Color[3]);
      glVertex3f(0, posy, posz);
    }
  
    glEnd();
  
    glBegin(GL_TRIANGLE_FAN);
  
    // Draw a fan of tris beginning for the flat section of the arrow head
    glColor4fv(Color);
    glVertex3f(0,0,0);
    for (Ang=0;Ang<=360;Ang+=10) {
      float posy, posz, factor;
      posy = (float)(Radius*cos(Ang/180.0*M_PI));
      posz = (float)(Radius*sin(Ang/180.0*M_PI));
      factor = (float)((fabs(Ang-180))/360);
    
      glColor4f(Color[0]*factor, Color[1]*factor, Color[2]*factor, Color[3]);
      glVertex3f(0, posy, posz);
    }
  
    glEnd();
  
    return 1;
  }


  void glDrawText(float x, float y, const char *text) {
    glRasterPos2d(x,y);
    glListBase(GL_FONT_START);
    glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
  }

  void glDrawText(float x, float y, const std::string &text) {
    glRasterPos2d(x,y);
    glListBase(GL_FONT_START);
    glCallLists(text.length(), GL_UNSIGNED_BYTE, text.c_str());
  }

  void glDrawText(float x, float y, const char *text, AztecGLFont *font) {
    font->draw(x, y, text);
  }

  void glDrawText(float x, float y, const std::string &text, AztecGLFont *font) {
    font->draw(x, y, text.c_str());
  }
}
