/******* AztecConsole.cpp ********
 **
 ** This is a simple console interface to Aztec so it will be easy
 ** to test the library functions of Aztec without having to use
 ** a GUI interface. This will allow any system that supports standard
 ** C++ to be able to be used for testing of Aztec.
 **
 ** The following functions will be supported at first:
 **   + Import of all supported formats
 **   + Export of all supported formats
 **   + Ability to call Povray Renderer for a loaded file
 **   + Ability to call JavaScript functions 
 **   + More will be added in the future...
 **
 ** To build (In Linux):
 **   + Use 'make all' in root directory of AztecLib
 **   + Use 'make all' in root directory of StdTranslators
 **   + Use 'make all' in root directory of AztecConsole
 **   
 **
 **
 **********************************/


#include <iostream.h>
#include <string>
#include <stdio.h>

//Aztec stuff

#include "MCompleteTranslator.h"
#include "MScene.h"
#include "MSystemManager.h"


#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


using std::string;
using namespace Aztec;

int ImportFile (const char *file);
int ExportFile (const char *file);
bool RenderFile (const char *file);
void JSInterp ();

MScenePtr          g_Scene;
MSystemManagerPtr   g_SysMan = MSystemManager::getInstance();

int main(int argc, char *argv[])
{
  string currentFile;
  string textInput;
  char buf[1024];
  int option;

  cout << endl << "Welcome to Aztec 3D Modeller Console Version!!" << endl;
  cout << endl << "Use the menu below to test out functions of Aztec" << endl;
  
  while (1)
  {
  cout << endl <<endl;
  cout << "1 - Import A File" << endl;
  cout << "2 - Export A File" << endl;
  cout << "3 - Render Current File" << endl;
  cout << "4 - Use JavaScript Interpreter" << endl;
  cout << "5 - Quit" << endl;
   
  cout << endl << "Enter option: ";
  cin >> option;

  switch (option)
  {
  case 1:
	cout << "Enter filename to import: ";
	cin.ignore(80, '\n');
	cin.getline(buf, 1024);
	currentFile = buf;
	ImportFile (currentFile.c_str());
	break;

  case 2:
	cout << "Enter filename to export to: ";
	cin.ignore(80, '\n');
	cin.getline(buf, 1024);
	currentFile = buf;
	ExportFile (currentFile.c_str());
	break;

  case 3:
	RenderFile (currentFile.c_str());
	break;

  case 4:
	JSInterp();
	break;

  case 5:
	return 0;

  default:
	cout << "ERROR! Sorry, I do not understand option: " << option << endl;
	cout << "Please choose again!" << endl;
	break;
  }
  }
  
  return 0;
}


int ImportFile (const char *file)
{
  cout << endl << "Importing " << file << "..." <<endl;

  int Res;
  MSceneTranslatorPtr Trans;


  MSceneTranslatorPtr SceneTrans;
     
  
  
  FILE *tf;
  tf = fopen(file, "r");
  
  if (!tf)
  {
	cout << "Could not open: " << file << endl;
  }
  else
  {
	cout << "Opened: " << file << endl;
	fclose(tf);
  }
  
  //return 1;

  cout << "Looking for translator..." << endl;
  //SceneTrans = g_SysMan->findSceneTranslatorThatImports(file);
  
  // If SceneTrans is NULL, then no importers are available for that file
  if (SceneTrans == NULL) 
  {
    cout << "No suitable Translator could be found for: " << file << endl;
    return 1;
  }

  cout << "geting res" << endl;
  Res = SceneTrans->importFile(file, g_Scene);
  
      
  if (!Res) 
  {
    cout << "Translator Could not import file " << file << endl;
	exit(0);
  } 
  else 
  {
   cout << "Translator imported " << file << " successfully." << endl;
   exit(0);
  }
  
  return Res;
}


int ExportFile (const char *file)
{
  cout << endl << "Exporting " << file << "..." <<endl;

  
  int Res;
  MSceneTranslatorPtr Trans;
  
 
  //Trans = g_SysMan->findSceneTranslatorThatExports(file);
  

  // if we have a translator, then export it.
  if (Trans != NULL) 
  {
    Res = Trans->exportFile(file, g_Scene);
  } 
  else 
  {
    cout << "Could not find the appropriate exporter for file " << file << endl;
    Res = 0;
  }
  
  return Res;

}


bool RenderFile (const char *file)
{
  //cout << endl << "Rendering " << file << "..." <<endl;
  cout << endl << "Wait to render another day foo!" << endl;
  return 0;
}


void JSInterp ()
{
  cout << endl << "Sorry, Mr JavaScript Interpreter is out for the day! Come back tommorrow!" << endl;
}

