#ifndef MOpenFileDialog_Header
#define MOpenFileDialog_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMOpenFileDialog;
  class MOpenFileDialog;

  typedef MRefCountedPtr<IMOpenFileDialog> IMOpenFileDialogPtr;
  typedef MRefCountedPtr<MOpenFileDialog> MOpenFileDialogPtr;

}

#include <gui/MFileDialog.h>
#include <string>

namespace Aztec {

  class AZTECGUI_EXPORT IMOpenFileDialog : public virtual IMFileDialog {
  protected:
    IMOpenFileDialog() { }
    ~IMOpenFileDialog() { }

  public:
    /**
     * Sets wether or not multiple selection is allowed. It is off by default.
     *
     * @param multipleSelect true if we allow the user to pick more than one 
     *                       file, false if we do not.
     */
    virtual void setMultipleSelect(bool multipleSelect) = 0;

    /**
     * Gets all the selected filenames
     *
     * @param filenames The vector of filesnames that will be filled up with
     *        all the selected files.
     */
    virtual void getFilenames(std::vector<std::string> &filenames) = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MOpenFileDialogImpl.h>


#endif

