#ifndef MRect2D_Header
#define MRect2D_Header

namespace Aztec {

  class AZTECGUI_EXPORT MRect2D {
  public:

    MRect2D() : x1(0), y1(0), x2(0), y2(0) { }
    MRect2D(int X1, int Y1, int X2, int Y2) : x1(X1), y1(Y1), x2(X2), y2(Y2) { }
    MRect2D(int width, int height) : x1(0), y1(0), x2(width), y2(height) { }
    MRect2D(const MPoint2D &topLeft, const MPoint2D &bottomRight) 
      : x1(topLeft.x), y1(topLeft.y), x2(bottomRight.x), y2(bottomRight.y) { }
    MRect2D(const MRect2D &src) : x1(src.x1), y1(src.y1), x2(src.x2), y2(src.y2) { }

    static inline MRect2D getLargest(const MRect2D &a, const MRect2D &b) {
      return MRect2D(a.x1 < b.x1 ? a.x1 : b.x1, 
                     a.y1 < b.y1 ? a.y1 : b.y1, 
                     a.x2 > b.x2 ? a.x2 : b.x2, 
                     a.y2 > b.y2 ? a.y2 : b.y2);

    }

    inline int getLeft() const {
      return x1;
    }

    inline int getRight() const {
      return x2;
    }

    inline int getTop() const {
      return y1;
    }

    inline int getBottom() const {
      return y2;
    }

    inline int getWidth() const {
      return x2 - x1;
    }

    inline int getHeight() const {
      return y2 - y1;
    }

    /**
     * Changes the right hand side of the rectangle, and makes it so getWidth() returns the given value.
     */
    inline void setWidth(int width) {
      x2 = x1 + width;
    }

    /**
     * Changes the bottom of the rectangle, and makes it so getHeight() returns the given value.
     */
    inline void setHeight(int height) {
      y2 = y1 + height;
    }

    inline void adjustWidth(int amount) {
      x2 += amount;
    }

    inline void adjustHeight(int amount) {
      y2 += amount;
    }

    /**
     * Returns true if the point is inside the rectangle, including the outer most lines.
     */
    inline bool contains(const MPoint2D &point) const {
      return ((point.x >= x1) && (point.x <= x2) && (point.y >= y1) && (point.y <= y2));
    }


    /**
     * The Left most coordinate of the rectangle.
     */
    int x1;

    /**
     * The Top most coordinate of the rectangle.
     */
    int y1;

    /**
     * The right most coordinate of the rectangle.
     */
    int x2;

    /**
     * The bottom  most coordinate of the rectangle.
     */
    int y2;
  
  };

}


#endif

