#ifndef MSaveFileDialog_Header
#define MSaveFileDialog_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMSaveFileDialog;
  class MSaveFileDialog;

  typedef MRefCountedPtr<IMSaveFileDialog> IMSaveFileDialogPtr;
  typedef MRefCountedPtr<MSaveFileDialog> MSaveFileDialogPtr;

}

#include <gui/MFileDialog.h>
#include <string>

namespace Aztec {

  class AZTECGUI_EXPORT IMSaveFileDialog : public virtual IMFileDialog {
  protected:
    IMSaveFileDialog() { }
    ~IMSaveFileDialog() { }

  public:

    /**
     * Sets wether or not the confirmation dialog to overwrite a file or not should be displayed. The default is true.
     *
     * @param showPrompt true if we want the confirmation dialog to appear, false if we do not.
     */
    virtual void setOverwritePrompt(bool showPrompt) = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MSaveFileDialogImpl.h>


#endif

