#ifndef MTextField_Header
#define MTextField_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMTextField;
  class MTextField;

  typedef MRefCountedPtr<IMTextField> IMTextFieldPtr;
  typedef MRefCountedPtr<MTextField> MTextFieldPtr;

}

#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>

#include <string>


namespace Aztec {

  /**
   * This class represents a simple text entry field. The user can type in 
   * letters or numbers into the field and perform simple copy and paste 
   * operations.
   */
  class AZTECGUI_EXPORT IMTextField : public virtual IMComponent {
  protected:
    IMTextField() { }
    ~IMTextField() { }

  public:
    class TextListener : public MRefCountedObject {
    public:
      virtual void onListen(const MTextFieldPtr &field) = 0;
    };

    typedef MRefCountedPtr<TextListener> TextListenerPtr;

    /**
     * Sets the current value for the text field. After setting this value, 
     * it should appear inside the edit control, and the onChange() method 
     * should be called.
     */
    virtual void setValue(const std::string &value) = 0;

    /**
     * Gets the current value for the text field. 
     */
    virtual std::string getValue() = 0;

    /**
     * This is called after the value in the box has been changed.
     */
    virtual bool onChanged() = 0;

    virtual bool onAccepted() = 0;
    virtual bool onCancelled() = 0;

    /**
     * Adds a listener that is notified when the value in the text field is accepted.
     */
    virtual void addAcceptListener(const TextListenerPtr &listener) = 0;

    /**
     * Adds a listener that is notified when the user has cancelled the current value in the text field.
     */
    virtual void addCancelListener(const TextListenerPtr &listener) = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MTextFieldImpl.h>


#endif

