#ifndef MToolWindow_Header
#define MToolWindow_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MToolWindow;
  class IMToolWindow;

  typedef MRefCountedPtr<MToolWindow> MToolWindowPtr;
  typedef MRefCountedPtr<IMToolWindow> IMToolWindowPtr;

}

#include <gui/MWindow.h>

namespace Aztec {


  /**
   * This MWindow class is a framed window object. That is a top level, 
   * floating window that usually represents a single running application.
   */
  class AZTECGUI_EXPORT IMToolWindow : public virtual IMWindow {
  protected:
    IMToolWindow() { }
    ~IMToolWindow() { }

  public:

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MToolWindowImpl.h>


#endif

