
#ifndef MAppImpl_Header
#define MAppImpl_Header

#include "gui/MGuiBase.h"
#include "gui/MApplication.h"
#include "gui/MWindow.h"

#include <qapplication.h>
#include <qwidget.h>

#include <string>
#include <map>
#include <set>

namespace Aztec {


#define AZTEC_USE_APP(AppClass)                  \
  int main(int argc, char** argv) {              \
                                                 \
    AppClass *app = new AppClass();              \
                                                 \
    app->qt3init("appname", argc, argv);        \
    Aztec::IMApp::Ptr appPtr = app;              \
                                                 \
    if (!app->initApp()) {                       \
      return false;                              \
    }                                            \
                                                 \
    int result = app->run();                     \
    app->cleanup();                              \
                                                 \
    appPtr = NULL;                               \
    return result;                               \
  }


  class AZTECGUI_EXPORT MApp : public virtual Aztec::IMApp {
  public:
    MApp();
    ~MApp();

    static MApp* getInstance();

    void qt3init(const std::string& appName, int argc, char** argv);

    /**
     * This gets a component given a QWidget
     */
    MComponentPtr getComponent(QWidget* Handle);

    /**
     * This registers a component to a QWidget
     */
    void registerComponent(QWidget* Handle, const MComponentPtr& component);

    void unregisterComponent(QWidget* Handle);

    /*void registerMenu(MPopupMenu* item);
    /void unregisterMenu(MPopupMenu* item);

    MPopupMenu* getItemFromID(WORD id);*/

    // MApp methods
    bool initApp();
    int run();
    void cleanup();
    std::string getName();
    std::string getApplicationPath();
    MWindowPtr getTopLevelWindow();
    bool onCommand(const std::string &command, const MComponentPtr &component);
    bool onMouseMove(const MMouseEvent &event);
    bool onMousePressed(const MMouseEvent &event);
    bool onMouseReleased(const MMouseEvent &event);
    bool onKeyPressed(const MKeyEvent &event);
    bool onKeyReleased(const MKeyEvent &event);

    // TODO: Make protected and use m_ prefix
    std::string appPath;

  protected:
    /**
     * This is the name of the application
     */
    std::string m_Name;

    /**
     * just a list of all the MWindow's in the application
     */
    std::set<MWindowPtr> m_AllWindows;

    /**
     * This is a mapping from Qt widget handles to MWindow's
     */
    std::map<QWidget*, MComponentPtr> m_HandleMap;

    /*typedef std::map<unsigned short, MMenuItem*> IDMenuItemMap;

    IDMenuItemMap menuItemMap;*/
  };


}


#endif

