
#ifndef MComboBoxImpl_Header
#define MComboBoxImpl_Header

#include <AztecGUICommon.h>

#include <string>
#include <vector>


namespace Aztec {

  class AZTECGUI_EXPORT MComboBox : public virtual Aztec::IMComboBox, public MComponent {
  public:
    MComboBox();
    ~MComboBox();

    // MComponentImpl methods
    virtual bool createImpl();

    // MComboBox Methods
    void setValue(const std::string &value);
    std::string getValue();

    void addItem(const std::string &item);
    void insertItem(const std::string &item, int index);
    void removeItem(const std::string &item);
    void removeItem(int index);
    void removeAllItems();
    int findItem(const std::string &item);

    int getItemCount();

    int getSelectedIndex();
    std::string getSelectedItem();
    void setSelectedIndex(int index);
    void setSelectedItem(const std::string &item);

    void showDropDown();
    void hideDropDown();
    bool isDropDownVisible();

    bool onChanged();
    void addListener(const ListenerPtr &listener);
  }

  protected:
    std::vector<ComboBoxListenerPtr> listeners;

    void notifyListeners();


  };

}


#endif

