
#ifndef MWindowImpl_Header
#define MWindowImpl_Header

#include <gui/MWindow.h>
#include <gui/qt3/MContainerImpl.h>

#include <string>

#include <qmainwindow.h>


namespace Aztec {

  class AZTECGUI_EXPORT MWindow : public virtual Aztec::IMWindow, public MContainer {
  public:

    MWindow(const std::string &title);
    ~MWindow();

    // MComponentImpl methods
    virtual bool createImpl();

    // MWindow methods
    bool create();
    void setTitle(const std::string &title);
    std::string getTitle();
    void setMenu(MMenuPtr menu);
    MMenuPtr getMenu();
    void close();
    bool onClose();

    // MComponent methods
    /*void setParent(MContainerPtr parent);
    MComponentPtr getParent();
    void setVisible(bool visible);
    void setPosition(const MPoint2D &pos);
    void setPosition(int X, int Y);
    void setPosition(int X, int Y, int width, int height);
    MPoint2D getPosition();
    void setSize(const MPoint2D &size);
    void setSize(int width, int height);
    MRect2D getWindowRect();
    void setWindowRect(const MRect2D &rect);*/

  protected:
    /**
     * This is the title that appears in the window title bar.
     */
    std::string m_Title;
  };

}

#endif

