
#ifndef QPopupMenu_Header
#define QPopupMenu_Header

#include <string>
#include <iostream>

#include <qpopupmenu.h>

#include "gui/MApplication.h"
#include "gui/MMenu.h"
#include "gui/MMenuItem.h"


/**
 * Custom QPopupMenu class for passing signals into AztecGUI
 */
class CQPopupMenu_ : public QPopupMenu {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQPopupMenu_(/*QWidget* parent,*/ const Aztec::MMenuPtr ref)
    : QPopupMenu(/*parent -- no parent means we should delete the menu ourselves !!*/),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(activated(int)), SLOT(onActivated(int)));
  };

  ~CQPopupMenu_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MMenu that is using us
   */
  Aztec::MMenuPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  // Already defined

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  void onActivated(int ID) {
    std::cout << "MMenu::click [" << ID << "]" << std::endl;

    Aztec::MMenuItemPtr item = m_Ref->getItem(ID);
    Aztec::MApp* app = Aztec::MApp::getInstance();

    bool handled = app->onCommand(item->getCommand(), 0l);
    if (!handled) item->onClick();

/*    Aztec::MActionPtr action = m_Ref->getItem(ID);
    Aztec::MApp* app = Aztec::MApp::getInstance();

    bool handled = app->onCommand(action->getCommand(), 0l);
    if (!handled) action->onClick();*/

    //m_Ref->onClick();
  }

};


#endif

