#ifndef AztecMenuFactory_Header
#define AztecMenuFactory_Header

#include <gui/MMenu.h>

#include <istream>

namespace Aztec {


  class AZTECGUI_EXPORT MMenuFactory {
  public:

    MMenuFactory();

    /**
     * Loads a menu from a filename.
     */
    static MMenuPtr loadMenu(const std::string &filename, const MMenuItem::ListenerPtr &listener = NULL);

    /**
     * Loads a menu from a filename.
     */
    static void loadMenu(const MMenuShellPtr &menu, const std::string &filename, const MMenuItem::ListenerPtr &listener = NULL);

    static void loadMenu(const MMenuShellPtr &menu, int index, const std::string &filename, const MMenuItem::ListenerPtr &listener = NULL);
  };

}

#endif
