#ifndef MButtonImpl_Header
#define MButtonImpl_Header

#include <gui/MButton.h>
#include <gui/win32/MComponentImpl.h>
#include <gui/win32/MDIBImage.h>

#include <string>

#include <windows.h>

namespace Aztec {

  class AZTECGUI_EXPORT MButton : public virtual Aztec::IMButton, public MComponent {
  public:
    /**
     * Constructs a button with the given caption, command and preferred size.
     */
    MButton(const std::string &caption = "", 
            const std::string &command = "", 
            Aztec::MSize2D prefSize = Aztec::MSize2D(-1,-1));
    ~MButton();

    /**
     * This creates the implementation window
     */
    virtual bool createImpl();

    // MButton Methods
    void setCaption(const std::string &caption);
    std::string getCaption();
    void setCommand(const std::string &command);
    std::string getCommand();
    bool onClick();
    void setButtonDown(bool buttonDown);
    bool getButtonDown();
    void setImage(const Aztec::MImagePtr &image);
    void addListener(const MButtonListenerPtr &listener);

    // MComponent methods
    MSize2D getMinimumSize();
    bool isMinimumSizeSet();

    void fireClickListeners();

    WNDPROC lpfnOldWndProc;
  protected:
    std::string m_Caption;
    std::string m_Command;

    MSize2D minSize;
    MSize2D minButSize;

    bool buttonDown;

    MDIBImage bitmap;
    MImagePtr image;

    std::vector<MButtonListenerPtr> listeners;

    void updateMinButSize();
  };

}


#endif