#ifndef MFileDialogImpl_Header
#define MFileDialogImpl_Header

#include <gui/MFileDialog.h>
#include <vector>

#include <windows.h>

namespace Aztec {

  class AZTECGUI_EXPORT MFileDialog : public virtual IMFileDialog {
  public:
    MFileDialog();

    // MFileDialog methods
    void setFilename(const std::string &filename);
    void setPath(const std::string &path);
    void addFilter(const std::string &description, const std::string &filter);
    void setFilter(int index);
    bool doModal();
    std::string getFilename();
    int getFilter();
    void setTitle(const std::string &title);

  protected:
    std::string filename;    
    std::string path;    
    std::string title;
    std::string ofnFilters;

    typedef enum {FILENAME_BUFFER_SIZE = 16384} SizeEnums;
    char filenameBuffer[FILENAME_BUFFER_SIZE];

    typedef std::pair<std::string, std::string> FilterPair;
    std::vector<FilterPair> filters;

    int selectedFilter;

    virtual void setupOFN(OPENFILENAME &ofn);
    virtual BOOL showDialog(OPENFILENAME &ofn) = 0;
    virtual void extractFilename(OPENFILENAME &ofn) = 0;
    virtual int getWindowsFilters(std::string &ofnFilters) = 0;
  private:
    OPENFILENAME ofn;
  };

}

#endif

