#ifndef MSliderImpl_Header
#define MSliderImpl_Header

#include <gui/MSlider.h>
#include <gui/win32/MComponentImpl.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MSlider : public virtual Aztec::IMSlider, public MComponent {
  public:

    MSlider(int min = 0, int max = 100, int pos = 0);
    ~MSlider();

    // MComponentImpl methods
    bool createImpl();
    bool wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result);

    // MSlider Methods
    void setValue(int value);
    int getValue();

    void setRange(int min, int max);
    void setMinimum(int min);
    void setMaximum(int max);
    int getMinimum();
    int getMaximum();
    bool onChanged();
    void addListener(const SliderListenerPtr &listener);

    // MComponent methods
    bool isMinimumSizeSet();
    MSize2D getMinimumSize();


  protected:

    /// The minimum size of the text
    MSize2D minSize;

    /// the starting minimum and maximum values
    int startMin, startMax, startPos;

    std::vector<SliderListenerPtr> listeners;
  };

}


#endif