/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/MFileDialog.h>
#include <gui/MApplication.h>

#include <iostream>


namespace Aztec {
  MFileDialog::MFileDialog() {
    selectedFilter = ALL_KNOWN_FILES;
    strcpy(filenameBuffer, "");
  }

  // MFileDialog methods
  void MFileDialog::setFilename(const std::string &filename) {
    this->filename = filename;
  }

  void MFileDialog::setPath(const std::string &path) {
    this->path = path;
  }

  void MFileDialog::addFilter(const std::string &description, const std::string &filter) {
    filters.push_back(FilterPair(description, filter));
  }

  void MFileDialog::setFilter(int index) {
    selectedFilter = index;
  }

  bool MFileDialog::doModal() {

    MApp* app = MApp::getInstance();

    // Setup a new file dialog
    QFileDialog* fd = new QFileDialog(
                          app->getTopLevelWindow()->getHandle(),
                          "Choose a file", true);

    // Display the open/save dialog and let the
    // user pick a file..
    bool result = showDialog(fd);

    // Extrac the bits of information
    if (result != 0) {
      // extractFilename(..);
      // + filename = fd->selectedFile();

      delete fd;
      return true;
    }
    else {
      delete fd;
      return false;
    }

  }

  std::string MFileDialog::getFilename() {
    // The absolute filename is stored in the path and filename variables.
    if (path.find_last_of('/') + 1 == path.length()) {
      std::cout << "path: " << path + filename << std::endl;
      return path + filename;
    } 
    else {
      std::cout << "path: " << path + "/" + filename << std::endl;
      return path + "/" + filename;
    }
  }

  int MFileDialog::getFilter() {
    return selectedFilter;
  }

  void MFileDialog::setTitle(const std::string& title) {
    this->title = title;
  }

}

