/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/MApplication.h>
#include <gui/MTreeControl.h>

#include <gui/qt3/QListView_.moc>

#include <iostream>


namespace Aztec {

  MTreeControl::MTreeControl() {
  }


  MTreeControl::~MTreeControl() {
  }

  bool MTreeControl::createImpl() {
    MApp* app = MApp::getInstance();

    // Only create the listview once
    if (m_Handle != 0l) {
      return true;
    }

    QWidget* parentWnd = 0l;
    if (m_Parent != 0l) m_Parent->getHandle();

    m_Handle = new CQListView_(parentWnd, this);

    if (m_Handle != 0l) {
      app->registerComponent(m_Handle, this);

      onCreate();

      // NOTE: Do not call setVisible, ever (see other Qt impl sources).
      //setVisible(true);

      return true;
    }

    return false;
  }

  void MTreeControl::selectItem(const MTreeItemPtr &item, bool selected) {
    QListView* lv = dynamic_cast<QListView*>(m_Handle);
//    if (lv != 0) lv->setSelected(item->m_lviHandle, selected);
  }

  void MTreeControl::clear() {
    QListView* lv = dynamic_cast<QListView*>(m_Handle);
    if (lv != 0) lv->clear();
  }

  MTreeItemPtr MTreeControl::addItem(const std::string &text) {
    return addItem(text, 0l);
  }

  MTreeItemPtr MTreeControl::addItem(const std::string &text, const MTreeItemPtr &parent) {
    QListView* lv = dynamic_cast<QListView*>(m_Handle);
    // Setup a new tree item
    MTreeItemPtr tip;
    tip = new MTreeItem(/*lv*/this, parent != 0l ? parent->m_lviHandle : 0l);

    // TODO: Additional setup for item?
    QListViewItem* lvi = tip->m_lviHandle;
    lvi->setText(m_col, text.c_str());

    if (lv != 0) lv->insertItem(lvi);

    return tip;
  }

  void MTreeControl::expandItem(const MTreeItemPtr &item, bool expand) {
    // TODO: Implementation
  }

  bool MTreeControl::onItemSelected(const MTreeItemPtr &item) {
    return false;
  }



  //-------------

  MTreeItem::MTreeItem() {
  }

  MTreeItem::MTreeItem(const MTreeItem &src) {
    // TODO: Implementation
  }

  MTreeItem::MTreeItem(MTreeControlPtr handle, QListViewItem* parent) {
    m_lviHandle = new QListViewItem(dynamic_cast<QListView*>(handle->getHandle()), parent);
  }

  // IMTreeItem methods.
  std::string MTreeItem::getText() const {
    //return (std::string)m_lviHandle->text(m_parent->m_col);
    return "dummy";
  }

  int MTreeItem::compare(const MTreeItemPtr &rhs) {
    // TODO: Implementation
    return 0;
  }

  MTreeItemPtr MTreeItem::getParent() const {
    // TODO: Implementation
    return 0l;
  }

  bool MTreeItem::getSelected() const {
    return m_lviHandle->isSelected();
  }


}

