#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MScrolledContainer.h>

#include <assert.h>

namespace Aztec {


  static JSBool js_MScrolledContainer_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    
    MScrolledContainerPtr newComponent = new MScrolledContainer();
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }
  
  static const int HorizontalVisible = 0;
  static const int VerticalVisible = 1;
  
  static JSBool js_MScrolledContainer_getProperty(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MScrolledContainerPtr scroller = getGuiObject<MScrolledContainer>(cx, obj);

    if (scroller != NULL) {

      if (JSVAL_IS_INT(id)) {
        switch (JSVAL_TO_INT(id)) {
        case HorizontalVisible:
          *rval = INT_TO_JSVAL(scroller->getVisibility(MScrolledContainer::HorizontalScroller));
          return JS_TRUE;
        case VerticalVisible:
          *rval = INT_TO_JSVAL(scroller->getVisibility(MScrolledContainer::VerticalScroller));
          return JS_TRUE;
        default:
          JS_ReportError(cx, "Unknown property '%i' to set on the scrolled container.", id);
        }
      } else {
        JS_ReportError(cx, "Non-integer ID supplied to js_MScrolledContainer_getProperty.");
      }

    } else {
      JS_ReportError(cx, "Could not find the MScrolledContainerPtr for this js object.");
    }
    
    return JS_FALSE;
  }

  static MScrolledContainer::VisiblityEnum convertToVis(int32 value) {
    if (value == MScrolledContainer::Always) {
      return MScrolledContainer::Always;
    } else if (value == MScrolledContainer::Automatic) {
      return MScrolledContainer::Automatic;
    } else if (value == MScrolledContainer::Never) {
      return MScrolledContainer::Never;
    } else {
      assert(0);
      return MScrolledContainer::Never;
    }
  }

  static JSBool js_MScrolledContainer_setProperty(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    MScrolledContainerPtr scroller = getGuiObject<MScrolledContainer>(cx, obj);

    if (scroller != NULL) {

      int32 value = -1;

      if (!JS_ValueToInt32(cx, *js_value, &value)) {
        JS_ReportError(cx, "Value passed to js_MScrolledContainer_setProperty is not an integer");
        return JS_FALSE;
      }

      if (JSVAL_IS_INT(id)) {
        switch (JSVAL_TO_INT(id)) {
        case HorizontalVisible:
          scroller->setVisibility(MScrolledContainer::HorizontalScroller, convertToVis(value));
          return JS_TRUE;
        case VerticalVisible:
          scroller->setVisibility(MScrolledContainer::VerticalScroller, convertToVis(value));
          return JS_TRUE;
        default:
          JS_ReportError(cx, "Unknown property '%i' to set on the scrolled container.", id);
        }
      } else {
        JS_ReportError(cx, "Non-integer ID supplied to js_MScrolledContainer_setProperty.");
      }

    } else {
      JS_ReportError(cx, "Could not find the MScrolledContainerPtr for this js object.");
    }


    return JS_FALSE;
  }

  
  static JSClass js_MScrolledContainer_class = {
    "MScrolledContainer", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  static JSFunctionSpec js_MScrolledContainer_methods[] = {
    {NULL,                NULL,                   0} 
  };
  
  static JSPropertySpec js_MScrolledContainer_props[] = {
    {"horizontal", HorizontalVisible, JSPROP_ENUMERATE, js_MScrolledContainer_getProperty, js_MScrolledContainer_setProperty }, 
    {"vertical", VerticalVisible, JSPROP_ENUMERATE, js_MScrolledContainer_getProperty, js_MScrolledContainer_setProperty },
    {0, 0, 0, 0}
  };


  JSObject* initMScrolledContainerClass(JSContext *cx, JSObject *containerClass) {
    JSObject *object = JS_InitClass(cx, JS_GetGlobalObject(cx), containerClass,
      &js_MScrolledContainer_class, js_MScrolledContainer_constructor, 0,
      NULL, js_MScrolledContainer_methods, 0, 0);

    JS_DefineProperties(cx, object, js_MScrolledContainer_props);

    JSObject *con = JS_GetConstructor(cx, object);

    if (con != NULL) {
      JS_DefineProperty(cx, con, "ALWAYS", INT_TO_JSVAL(MScrolledContainer::Always), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "AUTOMATIC", INT_TO_JSVAL(MScrolledContainer::Automatic), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "NEVER", INT_TO_JSVAL(MScrolledContainer::Never), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
    }
    
    return object;
    
  }
}
