#ifndef LOGFILE_H
#define LOGFILE_H

#include "ModelGeneric.h"

namespace Aztec {

  class MLogFile;
  typedef MRefCountedPtr<MLogFile> MLogFilePtr;

}

#include "MStr.h"

#include <string>
#include <vector>

// Used a method to output information to one or several log files.

#define	LOG_PREFIXTIME	0x01
#define	LOG_PREFIXDAY	0x02
#define	LOG_PREFIXMONTH	0x04
#define	LOG_PREFIXYEAR	0x08
#define LOG_24HRTIME	0x10

#define LOG_PREFIXDATE	0x0E

namespace Aztec {
  
  class MLogFile;

  /**
   * This class is a listener that responds to text being sent to the
   * log file object. Each time a piece of text is recieved to the 
   * MLogFile object, the writeString() method is called.
   */
  class MGENEXPORT MLogFileListener : public MRefCountedObject {
  public:
    virtual void writeString(MLogFile *logfile, const std::string &text) = 0;
    virtual void writeLine(MLogFile *logfile, const std::string &text) = 0;
  };

  typedef MRefCountedPtr<MLogFileListener> MLogFileListenerPtr;

  /**
   * The MLogFile class allows text to be written to a series of files
   * and also as a place to distribute text to a number of listeners,
   * such as text boxes, other files or thing like that.
   */
  class MGENEXPORT MLogFile : public MRefCountedObject {
  protected:
    typedef std::vector<MLogFileListenerPtr> ListenerList;

    ListenerList listeners;
    
  public:
    int			m_Flags;
    
    MLogFile();
    MLogFile(MLogFile &Src);
    virtual ~MLogFile();
    
    void writeString(const char *Text);
    void writeString(const MStr &Text);
    void writeString(const std::string &text);

    void writeLine(const char *text);
    void writeLine(const MStr &text);
    void writeLine(const std::string &text);

    int addLogFile(const char *Text, bool clear=true);

    void addListener(const MLogFileListenerPtr &listener);
    void removeAllListeners();
  };
  
}
#endif // !defined(AFX_LOGFILE_H__CE1F1204_3F3C_11D2_9FF8_0040332C7B2F__INCLUDED_)
