#ifndef MEditableMesh_Header
#define MEditableMesh_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MEditableMesh;

  typedef MRefCountedPtr<MEditableMesh> MEditableMeshPtr;
}

#include <MMesh.h>
#include <MEditableComponentisedObject.h>
#include <MBaseUndoNode.h>

#include <vector>
#include <set>

namespace Aztec {

  //------------------
  //  MMesh
  //------------------
  class MGENEXPORT MEditableMesh : public MMesh,
                                   public virtual MEditableComponentisedObject {
  public:
    MEditableMesh();
    MEditableMesh(MMeshPtr src);
    ~MEditableMesh();
    
    // Class related
    MStr getClassName() {return MStr("MEditableMesh");}
    MStr getParentClassName() {return MStr("MMesh");}
    MBaseObjectPtr createNew();
    void setFrom(MBaseObjectPtr SrcObj);

    virtual void setFromMesh(MMeshPtr Mesh, int Append = 0, bool KeepFlags = false);
    
    void takeSnapshot();
    void retreiveSnapshot();
    
    virtual int addVertex(float x, float y, float z);
    virtual int addVertex(const MVector3 &pos);
    virtual int addVertexArray(const MVector3 Vert[], int Num = 1);
    virtual void deleteVertex(int Num);
    virtual void deleteVertexArray(const int *VertNums, int Num = 1);
    void deleteVertexFlag(AztecFlags Flag);
    
    virtual void addTriangle(int A, int B, int C);
    virtual void addTriangle(const MVector3 &A, const MVector3 &B, const MVector3 &C);
    virtual void addTriangleArray(const MInternalTriangle *Tri, int Num = 1);
    virtual void deleteTriangle(int TriNum);
    virtual void deleteTriangleArray(const int *TriNums, int Num = 1);
    void deleteTriangleFlag(AztecFlags Flag);
    
    void addVertsAndTriangles(MVector3 *Verts, MInternalTriangle *Tris, int NumVerts, int NumTris);
    
    void setVertexPosition(int index, const MVector3 &pos);
    void setVertexNormal(int index, const MVector3 &normal);

    void setTriangleVertex(int triIndex, int vertexIndex, int newMeshVertex);

    // Various Mesh editing functions.
    virtual int turnEdge(int EdgeNum);
    virtual int divideEdge(int EdgeNum, float Dist = 0.5);
    virtual int extrudeFaces(AztecFlags Flags, float Amount, const MVector3 &NormVec);
    virtual int separateFaces(TRIFLAGS Flags);
    virtual int collapseVertices(VERTFLAGS Flags);
    int collapseVertices(const std::vector<int> &vertices);
    virtual int weldVertices(VERTFLAGS Flags, float Threshold);

    bool divideEdgeWithVertex(int from, int to, int newVertex);
    int divideEdge(int vertFrom, int vertTo, const MVector3 &pos);
    
    // Move the mesh so that it centers on the origin
    void centerMesh();
    // Scale the mesh uniformly using the factor
    void scaleMesh(float Factor);
    // Reverse the order of the triangles in the mesh.
    int flipNormals(TRIFLAGS Flags);

    void triangulatePolygon(const std::vector<int> &vertices);
    
    // MEditableComponentisedObject methods
    void storeComponentPositions(AztecFlags type, AztecFlags flag = 0);
    void restoreComponentPositions(AztecFlags type, AztecFlags flag = 0);
    void transformComponents(AztecFlags type, 
                             const MMatrix4 &transform, 
                             AztecFlags flag = 0, 
                             bool localTransform = false,
                             TransformModifier *modifier = NULL);
    void updateComponentAnimation(AztecFlags type, AztecFlags flag, long time, bool createKey);
    void updateSingleComponentAnimation(AztecFlags type, int index, long time, bool createKey);

  protected:
    /**
     * This is a snapshot of the mesh. This is so that a mesh can be
     * easily copied, adn then changes can be made, and those
     * changes can be reversed very easily.
     */
    MEditableMeshPtr m_Snapshot;

    /**
     * This stores the component positions
     */
    std::vector<MInternalVertex> storedVertices;

  };

}
#endif
