#ifndef MLookAt_Header
#define MLookAt_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MLookAt;
  typedef MRefCountedPtr<MLookAt> MLookAtPtr;

}

#include "MMath.h"
#include "MSceneObject.h"

#include <params/MFloatParameter.h>

namespace Aztec {

  /**
   * This is a controller which changes the rotation
   * of an object so it will look at another object
   */
  class MGENEXPORT MLookAt : public MNamedObject {
  public:
    MLookAt();

    void setSource(MSceneObjectPtr sceneObj);
    void setSourceAxis(const MVector3 &vector);

    MSceneObjectPtr getTarget();
    void setTarget(MSceneObjectPtr sceneObj);

    bool doUpdateObject();


  protected:
    MVector3ParameterPtr outputRotation;
    MObjectParameterPtr target;
    MObjectParameterPtr inputParent;
    MVector3ParameterPtr inputTranslation;

    /**
     * This is the vector that will be matched up to point to the target.
     */ 
    MVector3ParameterPtr sourceAxis;

    /**
     * This is the amount of rotation to apply to the object after the aim 
     * constraint is applied.
     */
    MFloatParameterPtr roll;

    /**
     * This is the initial rotation vector
     */
    MVector3 m_InitialRot;

  };

}



#endif
