#ifndef MVertex_Header
#define MVertex_Header

#include <ModelGeneric.h>

#include <ModelTypes.h>
#include <MMath.h>

namespace Aztec {

  class MGENEXPORT MVertex {
  public:
    /**
     * This constructs a vertex that isn't associated with any mesh.
     * In this state, a vertex just contains a position in space. If this
     * empty vertex is assigned to a non empty vertex, the position only
     * is transferred across.
     */
    MVertex();

    MVertex(const MVertex &src);

    int getIndex();

    MVector3 getPos();
    void setPos(const MVector3 &pos);

    float getX();
    float getY();
    float getZ();

    MVector3 getNormal();
    void setNormal(const MVector3 &normal);

    MRGBAFloat getFeedbackColour();
    void setFeedbackColour(const MRGBAFloat &colour);

    MVertex& operator=(const MVertex &rhs);

  private:
    friend class MMesh;

    MVertex(MMesh *newMesh, int newIndex);

    MMesh* mesh;
    int index;
    MVector3 pos;
  }; 

}


#endif
