#ifndef MMatrix4Parameter_Header
#define MMatrix4Parameter_Header

#include <ModelGeneric.h>

namespace Aztec {
  
  class MMatrix4Parameter;
  typedef MRefCountedPtr<MMatrix4Parameter> MMatrix4ParameterPtr;

}

#include <MParameterObject.h>
#include <MMath.h>

namespace Aztec {
  
  class MGENEXPORT MMatrix4Parameter : public virtual MParameterObject {
  public:
    virtual const MMatrix4& getValue() = 0;

    virtual bool getValueMatrix(MMatrix4 &value) = 0;
    virtual bool setValueMatrix(const MMatrix4 &value) = 0;
  };

  class MGENEXPORT MMatrix4ParameterImpl : public virtual MMatrix4Parameter,
                                           public MParameterObjectImpl {
  public:
    MMatrix4ParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    virtual ~MMatrix4ParameterImpl();

    // MMatrix4Parameter methods
    virtual const MMatrix4& getValue();

    virtual bool getValueMatrix(MMatrix4 &value);
    virtual bool setValueMatrix(const MMatrix4 &value);

    // MParameterObject methods.
    int getDataType() const { return TYPE_MATRIX; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MMatrix4Parameter"); }
    bool doUpdateObject();

  protected:
    MMatrix4 m_Value;
    
  };
  
}

#endif
