#ifndef MObjectParameter_Header
#define MObjectParameter_Header

#include <ModelGeneric.h>

namespace Aztec {
  
  class MObjectParameter;
  typedef MRefCountedPtr<MObjectParameter> MObjectParameterPtr;

}

#include <MParameterObject.h>
#include <MNamedObject.h>

namespace Aztec {
  

  //---------------------------------------
  //  MObjectParameter
  //---------------------------------------
  class MGENEXPORT MObjectParameter : public virtual MParameterObject {
  public:
    virtual void setValue(MNamedObjectPtr value) = 0;
    virtual MNamedObjectPtr getValue() = 0;

  };

  //---------------------------------------
  //  MObjectParameterImpl
  //---------------------------------------
  class MGENEXPORT MObjectParameterImpl : public virtual MObjectParameter, 
                                          public MParameterObjectImpl {
  public:
    MObjectParameterImpl( const MStr &shortName = "", 
                      const MStr &longName = "", 
                      const MStr &friendlyName = "");
    ~MObjectParameterImpl();

    // MObjectParameter methods
    void setValue(MNamedObjectPtr value);
    MNamedObjectPtr getValue();

    // MParameterObject methods.
    int getDataType() const { return TYPE_OBJECT; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    bool createKeyAt(long time);
    MParameterObjectPtr createCopy();
    
    bool setInputParameter(const MParameterObjectPtr &input);

    // MBaseObject methods
    MStr getClassName() { return MStr("MObjectParameter"); }

  protected:
    /**
     * This is the object taht we refer to.
     */
    MNamedObjectPtr m_Object;

    /**
     * This is the name of the object we try to refer to.
     * If we can't find the object, this is its name. If 
     * we can find it, this empty.
     */
    MStr m_ObjectName;

    /**
     * This disconnects any relationship between this parameter and the
     * object
     */
    void disconnectParameter();

    /**
     * This connects any relationship between this parameter and the
     * object
     */
    void connectParameter();

  };


}

#endif
