#ifndef MTransformMatrixParameter_Header
#define MTransformMatrixParameter_Header

#include <params/MMatrix4Parameter.h>
#include <params/MVector3Parameter.h>

#include <MMath.h>

namespace Aztec {
  
  class MTransformMatrixParameter;

  typedef MRefCountedPtr<MTransformMatrixParameter> MTransformMatrixParameterPtr;

  //---------------------------------------
  //  MTransformMatrixParameter
  //---------------------------------------
  class MGENEXPORT MTransformMatrixParameter : public virtual MMatrix4Parameter,
                                               public MParameterObjectImpl {
  public:
    MTransformMatrixParameter( const MStr &shortName = "", 
                               const MStr &longName = "", 
                               const MStr &friendlyName = "",
                               MVector3ParameterPtr transParam = MVector3ParameterPtr(NULL), 
                               MVector3ParameterPtr rotParam = MVector3ParameterPtr(NULL), 
                               MVector3ParameterPtr scaleParam = MVector3ParameterPtr(NULL), 
                               MVector3ParameterPtr pivotParam = MVector3ParameterPtr(NULL), 
                               MMatrix4ParameterPtr parentXFormParam = MMatrix4ParameterPtr(NULL));
    virtual ~MTransformMatrixParameter();

    void setInputs( MVector3ParameterPtr transParam = MVector3ParameterPtr(NULL), 
                    MVector3ParameterPtr rotParam = MVector3ParameterPtr(NULL), 
                    MVector3ParameterPtr scaleParam = MVector3ParameterPtr(NULL), 
                    MVector3ParameterPtr pivotParam = MVector3ParameterPtr(NULL), 
                    MMatrix4ParameterPtr parentXFormParam = MMatrix4ParameterPtr(NULL));

    // MMatrix4Parameter
    const MMatrix4& getValue();
    bool getValueMatrix(MMatrix4 &value);
    bool setValueMatrix(const MMatrix4 &value);

    // MParameterObject methods.
    int getDataType() const { return TYPE_MATRIX; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &src);

    bool createKeyAt(long time);
    MParameterObjectPtr createCopy();
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MTransformMatrixParameter"); }
    bool doUpdateObject();

  protected:
    MMatrix4ParameterPtr m_ParentXForm;
    MVector3ParameterPtr m_Translate;
    MVector3ParameterPtr m_Rotate;
    MVector3ParameterPtr m_Scale;
    MVector3ParameterPtr m_Pivot;
    
    MMatrix4 m_Value;
  };
  
}

#endif
