#ifndef CSCRIPTCALLBACKS_H
#define CSCRIPTCALLBACKS_H

#include <stdio.h>
#include <vector>

#include "ModelGeneric.h"


// Class used to pass callbacks into the script interpreter.  Currently
// two callbacks are used.  The first is to output text strings, the
// second is to force a redraw/redisplay based on object updates.
class MGENEXPORT CScriptCallbacks {
public:
	typedef int actionFunc(void);		// Perform menu/keyboard action
  typedef int actionFuncWithArgs(const std::vector<std::string> &args, std::string &result);

  CScriptCallbacks();
  virtual ~CScriptCallbacks();

  virtual int puts(const char *str);
  virtual void updateDisplay();
  virtual actionFunc* getActionFunction(const char *actionName);
  virtual actionFuncWithArgs* getActionFunctionWithArgs(const char *actionName);
};

#endif // CSCRIPTCALLBACKS_H
