#include "StdAfx.h"

#include "MLight.h"
#include "MMesh.h"
#include "MEditableMesh.h"

#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include "ModelGLConst.h"

#include <MSystemManager.h>
#include <params/MParameterFactory.h>

#include <math.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {
//------------
//  MLight
//------------

  MLight::MLight() {
    setFlag(LIGHTFLAG_POINTLIGHT | LIGHTFLAG_LIGHTON | OBJECTFLAG_NOCOMPONENTS);
    setObjectType(OBJECTFLAG_TYPE_LIGHT);
    
    addParameter(MParameterFactory::createColour("Col", "Colour", "Colour"));
    addParameter(MParameterFactory::createColour("SpCol", "SpecColour", "Specular Colour"));
    addParameter(MParameterFactory::createFloat("Mul", "Multiplier", "Multiplier"));
    
    setParamByName("Col", "1 1 1");
    setParamByName("Mul", "1");
    setParamByName("SpCol", "0.5 0.5 0.5");
    
    // Make the mesh object now, so it isn't created/destroyed everytime the light is drawn
    MVector3 Verts[6];
    MInternalTriangle   Tris[8];
    
    Verts[0].set(0,0,2);
    Verts[1].set(2,2,0);
    Verts[2].set(-2,2,0);
    Verts[3].set(-2,-2,0);
    Verts[4].set(2,-2,0);
    Verts[5].set(0,0,-2);
    
    Tris[0] = MInternalTriangle(0,1,2);
    Tris[1] = MInternalTriangle(0,2,3);
    Tris[2] = MInternalTriangle(0,3,4);
    Tris[3] = MInternalTriangle(0,4,1);
    Tris[4] = MInternalTriangle(5,2,1);
    Tris[5] = MInternalTriangle(5,3,2);
    Tris[6] = MInternalTriangle(5,4,3);
    Tris[7] = MInternalTriangle(5,1,4);
    
    MEditableMeshPtr mesh = new MEditableMesh();

    mesh->addVertexArray(Verts, 6);
    mesh->addTriangleArray(Tris, 8);

    m_LightMesh = new MMesh();
    m_LightMesh->setFrom(mesh);
    
  }
  
  MLight::~MLight() {
    m_LightMesh = NULL;
  }
  
  MBaseObjectPtr MLight::createNew() {
    MLight   *NewLight;
    
    NewLight = new MLight;
    NewLight->setFrom(this);
    
    return NewLight;
  }
  
  void MLight::setFrom(MBaseObjectPtr SrcObj) {
    if (SrcObj == NULL) {
      return;
    }
    
    MShapeObject::setFrom(SrcObj);
    
    MLight      *Obj;
    
    Obj = AZTEC_CAST(MLight, SrcObj);
    
    if (!Obj) {
      return;
    }
    
  }
  
  MMeshPtr MLight::convertToMesh() {
    return m_LightMesh;
  }
  
  float getScaleFactor(const MVector3 &Vec)
  {
    float    Dist;
    MVector3 VecScreenSpace;
    MMatrix4 ModelViewMat;
    MMatrix4 inv;
    float    Mat[16];
  
    MVector3 o, a, b, x, y;

    double Factor;
  
    glGetFloatv(GL_MODELVIEW_MATRIX, Mat);
    ModelViewMat = MMatrix4(Mat);
    ModelViewMat.transpose();
    inv = ModelViewMat;
    inv.inverse();
    VecScreenSpace = ModelViewMat * Vec;
  
    Dist = -VecScreenSpace.z;
  
    Factor = Dist / 100.0;
  
    return (float)Factor;
  }


  bool MLight::drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags) {
    float Mat[16];
    float size = 2;
    
    glGetFloatv(GL_MODELVIEW_MATRIX, Mat);
    
    MVector3 XVec(Mat[0], Mat[4], Mat[8]);
    MVector3 YVec(Mat[1], Mat[5], Mat[9]);
    
    XVec.normalize();
    YVec.normalize();
    XVec *= size;
    YVec *= size;

    MParameterObjectPtr Param;
    Param = m_ParamList->getParameter("Col");

    MVector4 col(1,1,1,1);
    MVector4 rayColour(1,1,1,1);
    
    MVector3 lightColour;
    if (Param != NULL) {
      Param->getValueVector(lightColour);
      col = lightColour;
    }

    if (baseObj->isFlagged(OBJECTFLAG_SELECTED)) {
      col = ViewFlags.m_WireColor;
      rayColour = ViewFlags.m_WireColor;
    }

    glDisable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

    glColor4fv((float*)&col);

    glLineWidth(1);

    float factor = getScaleFactor(MVector3(0,0,0));
//    factor *= 1.5;
    factor = 2;

//    glBegin(GL_LINE_LOOP);
    glBegin(GL_TRIANGLE_FAN);
    glColor3fv((float*)&lightColour);
    glVertex3f(0,0,0);
    glColor4fv((float*)&col);
    for (float i = 0; i <= 360; i += 30) {
      MVector3 pos = (float)cos(i / 180.0 * 3.1415926535) * XVec + (float)sin(i / 180.0 * 3.1415926535) * YVec;
      pos *= factor * 0.75f;
      glVertex3fv((float*)&pos);
    }
    glEnd();

    glColor4fv((float*)&rayColour);
    glBegin(GL_LINES);
    for (float i = 0.0f; i < 360.0f; i += 45.0f) {
      MVector3 a = (float)cos(i / 180.0 * 3.1415926535) * XVec + (float)sin(i / 180.0 * 3.1415926535) * YVec;
      MVector3 b = a;
      a *= factor * 1.1f;
      b *= factor * 1.5f;
      glVertex3fv((float*)&a);
      glVertex3fv((float*)&b);
    }
    glEnd();

/*    
    Param = m_ParamList->getParameter("Col");
    
    MVector3 Col(1,1,1);
    
    if (Param != NULL) {
      Param->getValueVector(Col);
    }
    
    ViewFlags.m_GLLighting = false;
    glDisable(GL_TEXTURE_2D);
    //   if (!ObjNode->IsChildOfFlagged(OBJECTFLAG_SELECTED) || !ViewFlags.m_ShadeMode == glWire)
    ViewFlags.m_FlatColor.set(Col.x, Col.y, Col.z, 1);
    
    MMeshPtr  mesh;
    
    mesh = AZTEC_CAST(MMesh, convertToMesh());
    
    if (mesh != NULL) {
      mesh->drawObject(baseObj, ViewFlags);
    }
*/    
    return 1;
  }
  
  int MLight::selectComponent(AztecFlags Mode, int CompNum, bool TargetSel) {
    return 0;
  }
  
}
